package ext.data.validator {

[Native("Ext.data.validator.AbstractDate", require)]
/**
 * Base class for date type validators.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.AbstractDate.html Original Ext JS documentation of 'Ext.data.validator.AbstractDate'
 */
public class AbstractDateValidator extends Validator {
  /**
   * @inheritDoc
   */
  public function AbstractDateValidator(config:Validator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The format(s) to allow. See →<code>ext.DateUtil</code>.
   * @default ''
   * @see ext.#DateUtil ext.DateUtil
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.AbstractDate.html#cfg-format Original Ext JS documentation of 'format'
   * @see #getFormat()
   * @see #setFormat()
   */
  public native function get format():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set format(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when not valid.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.AbstractDate.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set message(value:String):void;

  /**
   * Returns the value of <code>format</code>.
   * @see #format
   */
  public native function getFormat():*;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  public native function getMessage():String;

  /**
   * Sets the value of <code>format</code>.
   * @param format The new value.
   * @see #format
   */
  public native function setFormat(format:*):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  public native function setMessage(message:String):void;
}
}