package ext.data.validator {

[Native("Ext.data.validator.Bound", require)]
/**
 * A superclass for a validator that checks if a value is within a certain range.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Bound.html Original Ext JS documentation of 'Ext.data.validator.Bound'
 */
public class BoundValidator extends Validator {
  /**
   * @param config @inheritDoc
   */
  public function BoundValidator(config:BoundValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not in the specified range
   * and both the minimum and maximum are specified.
   * @default 'Value must be between {0} and {1}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Bound.html#cfg-bothMessage Original Ext JS documentation of 'bothMessage'
   * @see #getBothMessage()
   * @see #setBothMessage()
   */
  public native function get bothMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set bothMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is empty.
   * @default 'Must be present'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Bound.html#cfg-emptyMessage Original Ext JS documentation of 'emptyMessage'
   * @see #getEmptyMessage()
   * @see #setEmptyMessage()
   */
  public native function get emptyMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set emptyMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum length value.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Bound.html#cfg-max Original Ext JS documentation of 'max'
   * @see #getMax()
   * @see #setMax()
   */
  public native function get max():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set max(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is more than the maximum
   * and only a maximum is specified.
   * @default 'Value must be less than {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Bound.html#cfg-maxOnlyMessage Original Ext JS documentation of 'maxOnlyMessage'
   * @see #getMaxOnlyMessage()
   * @see #setMaxOnlyMessage()
   */
  public native function get maxOnlyMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maxOnlyMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum length value.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Bound.html#cfg-min Original Ext JS documentation of 'min'
   * @see #getMin()
   * @see #setMin()
   */
  public native function get min():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set min(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is less than the minimum
   * and only a minimum is specified.
   * @default 'Value must be greater than {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Bound.html#cfg-minOnlyMessage Original Ext JS documentation of 'minOnlyMessage'
   * @see #getMinOnlyMessage()
   * @see #setMinOnlyMessage()
   */
  public native function get minOnlyMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minOnlyMessage(value:String):void;

  /**
   * Returns the value of <code>bothMessage</code>.
   * @see #bothMessage
   */
  public native function getBothMessage():String;

  /**
   * Returns the value of <code>emptyMessage</code>.
   * @see #emptyMessage
   */
  public native function getEmptyMessage():String;

  /**
   * Returns the value of <code>max</code>.
   * @see #max
   */
  public native function getMax():Number;

  /**
   * Returns the value of <code>maxOnlyMessage</code>.
   * @see #maxOnlyMessage
   */
  public native function getMaxOnlyMessage():String;

  /**
   * Returns the value of <code>min</code>.
   * @see #min
   */
  public native function getMin():Number;

  /**
   * Returns the value of <code>minOnlyMessage</code>.
   * @see #minOnlyMessage
   */
  public native function getMinOnlyMessage():String;

  /**
   * Sets the value of <code>bothMessage</code>.
   * @param bothMessage The new value.
   * @see #bothMessage
   */
  public native function setBothMessage(bothMessage:String):void;

  /**
   * Sets the value of <code>emptyMessage</code>.
   * @param emptyMessage The new value.
   * @see #emptyMessage
   */
  public native function setEmptyMessage(emptyMessage:String):void;

  /**
   * Sets the value of <code>max</code>.
   * @param max The new value.
   * @see #max
   */
  public native function setMax(max:Number):void;

  /**
   * Sets the value of <code>maxOnlyMessage</code>.
   * @param maxOnlyMessage The new value.
   * @see #maxOnlyMessage
   */
  public native function setMaxOnlyMessage(maxOnlyMessage:String):void;

  /**
   * Sets the value of <code>min</code>.
   * @param min The new value.
   * @see #min
   */
  public native function setMin(min:Number):void;

  /**
   * Sets the value of <code>minOnlyMessage</code>.
   * @param minOnlyMessage The new value.
   * @see #minOnlyMessage
   */
  public native function setMinOnlyMessage(minOnlyMessage:String):void;
}
}