package ext.data.validator {

[Native("Ext.data.validator.CIDRv4", require)]
/**
 * Validates that the value is a valid CIDR block.
 * <p>Works for both IPV4 only.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.CIDRv4.html Original Ext JS documentation of 'Ext.data.validator.CIDRv4'
 */
public class CIDRv4Validator extends FormatValidator {
  /**
   * @inheritDoc
   */
  public function CIDRv4Validator(config:FormatValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A matcher to check for valid CIDR block. This may be overridden.
   * @default /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\/([0-9]|[1-2][0-9]|3[0-2]))$/
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.CIDRv4.html#cfg-matcher Original Ext JS documentation of 'matcher'
   * @see #getMatcher()
   * @see #setMatcher()
   */
  override public native function get matcher():RegExp;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set matcher(value:RegExp):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid CIDR block.
   * @default 'Is not a valid CIDR block'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.CIDRv4.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  override public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set message(value:String):void;

  /**
   * Returns the value of <code>matcher</code>.
   * @see #matcher
   */
  override public native function getMatcher():RegExp;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  override public native function getMessage():String;

  /**
   * Sets the value of <code>matcher</code>.
   * @param matcher The new value.
   * @see #matcher
   */
  override public native function setMatcher(matcher:RegExp):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  override public native function setMessage(message:String):void;
}
}