package ext.data.validator {

[Native("Ext.data.validator.Currency", require)]
/**
 * Validates that the value is a valid U.S. currency value.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Currency.html Original Ext JS documentation of 'Ext.data.validator.Currency'
 */
public class CurrencyValidator extends NumberValidator {
  /**
   * @inheritDoc
   */
  public function CurrencyValidator(config:Validator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid currency amount.
   * @default 'Is not a valid currency amount'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Currency.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  override public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set message(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The spacer to show between the number and the currency symbol.
   * Defaults to {Ext.util.Format#currencySpacer}.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Currency.html#cfg-spacer Original Ext JS documentation of 'spacer'
   * @see #getSpacer()
   * @see #setSpacer()
   */
  public native function get spacer():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set spacer(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The symbol used to denote currency.
   * Defaults to {Ext.util.Format#currencySign}.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Currency.html#cfg-symbol Original Ext JS documentation of 'symbol'
   * @see #getSymbol()
   * @see #setSymbol()
   */
  public native function get symbol():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set symbol(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to show the currency symbol after the number.
   * Defaults to {Ext.util.Format#currencyAtEnd}.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Currency.html#cfg-symbolAtEnd Original Ext JS documentation of 'symbolAtEnd'
   * @see #getSymbolAtEnd()
   * @see #setSymbolAtEnd()
   */
  public native function get symbolAtEnd():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set symbolAtEnd(value:Boolean):void;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  override public native function getMessage():String;

  /**
   * Returns the value of <code>spacer</code>.
   * @see #spacer
   */
  public native function getSpacer():String;

  /**
   * Returns the value of <code>symbol</code>.
   * @see #symbol
   */
  public native function getSymbol():String;

  /**
   * Returns the value of <code>symbolAtEnd</code>.
   * @see #symbolAtEnd
   */
  public native function getSymbolAtEnd():Boolean;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  override public native function setMessage(message:String):void;

  /**
   * Sets the value of <code>spacer</code>.
   * @param spacer The new value.
   * @see #spacer
   */
  public native function setSpacer(spacer:String):void;

  /**
   * Sets the value of <code>symbol</code>.
   * @param symbol The new value.
   * @see #symbol
   */
  public native function setSymbol(symbol:String):void;

  /**
   * Sets the value of <code>symbolAtEnd</code>.
   * @param symbolAtEnd The new value.
   * @see #symbolAtEnd
   */
  public native function setSymbolAtEnd(symbolAtEnd:Boolean):void;
}
}