package ext.data.validator {

[Native("Ext.data.validator.Date", require)]
/**
 * Validates that the value is a valid date.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Date.html Original Ext JS documentation of 'Ext.data.validator.Date'
 */
public class DateValidator extends AbstractDateValidator {
  /**
   * @inheritDoc
   */
  public function DateValidator(config:Validator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The format(s) to allow. See →<code>ext.DateUtil</code>. Defaults to →<code>ext.DateUtil.defaultFormat</code>
   * @see ext.#DateUtil ext.DateUtil
   * @see ext.SDateUtil#defaultFormat ext.DateUtil.defaultFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Date.html#cfg-format Original Ext JS documentation of 'format'
   * @see #getFormat()
   * @see #setFormat()
   */
  override public native function get format():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set format(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid date.
   * @default 'Is not a valid date'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Date.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  override public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set message(value:String):void;

  /**
   * Returns the value of <code>format</code>.
   * @see #format
   */
  override public native function getFormat():*;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  override public native function getMessage():String;

  /**
   * Sets the value of <code>format</code>.
   * @param format The new value.
   * @see #format
   */
  override public native function setFormat(format:*):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  override public native function setMessage(message:String):void;
}
}