package ext.data.validator {

[Native("Ext.data.validator.Email", require)]
/**
 * Validates that the value is a valid email.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Email.html Original Ext JS documentation of 'Ext.data.validator.Email'
 */
public class EmailValidator extends FormatValidator {
  /**
   * @param config @inheritDoc
   */
  public function EmailValidator(config:EmailValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A matcher to check for simple emails. This may be overridden.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Email.html#cfg-matcher Original Ext JS documentation of 'matcher'
   * @see #getMatcher()
   * @see #setMatcher()
   */
  override public native function get matcher():RegExp;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set matcher(value:RegExp):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid email
   * @default 'Is not a valid email address'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Email.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  override public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set message(value:String):void;

  /**
   * Returns the value of <code>matcher</code>.
   * @see #matcher
   */
  override public native function getMatcher():RegExp;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  override public native function getMessage():String;

  /**
   * Sets the value of <code>matcher</code>.
   * @param matcher The new value.
   * @see #matcher
   */
  override public native function setMatcher(matcher:RegExp):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  override public native function setMessage(message:String):void;
}
}