package ext.data.validator {

[Native("Ext.data.validator.Exclusion", require)]
/**
 * Validates that the value does not exist in a →<code>list</code> of values.
 * @see #list
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Exclusion.html Original Ext JS documentation of 'Ext.data.validator.Exclusion'
 */
public class ExclusionValidator extends ListValidator {
  /**
   * @param config @inheritDoc
   */
  public function ExclusionValidator(config:ExclusionValidator = null) {
    super();
  }

  [ExtConfig]
  /**
   * The error message to return when the passed value exists in the
   * specified →<code>list</code>.
   * @default 'Is a value that has been excluded'
   * @see #list
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Exclusion.html#cfg-message Original Ext JS documentation of 'message'
   */
  public native function get message():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set message(value:String):void;
}
}