package ext.data.validator {

[Native("Ext.data.validator.Format", require)]
/**
 * Validates that the passed value matches a specific format specified by a regex.
 * The format is provided by the →<code>matcher</code> config.
 * @see #matcher
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Format.html Original Ext JS documentation of 'Ext.data.validator.Format'
 */
public class FormatValidator extends Validator {
  /**
   * @param config @inheritDoc
   */
  public function FormatValidator(config:FormatValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>. The matcher regex to test against the value.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Format.html#cfg-matcher Original Ext JS documentation of 'matcher'
   * @see #getMatcher()
   * @see #setMatcher()
   */
  public native function get matcher():RegExp;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set matcher(value:RegExp):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value does not match the format.
   * @default 'Is in the wrong format'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Format.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set message(value:String):void;

  /**
   * Returns the value of <code>matcher</code>.
   * @see #matcher
   */
  public native function getMatcher():RegExp;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  public native function getMessage():String;

  /**
   * Sets the value of <code>matcher</code>.
   * @param matcher The new value.
   * @see #matcher
   */
  public native function setMatcher(matcher:RegExp):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  public native function setMessage(message:String):void;
}
}