package ext.data.validator {

[Native("Ext.data.validator.IPAddress", require)]
/**
 * Validates that the value is a valid IP address.
 * <p>Works for both IPV4 and IPV6.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.IPAddress.html Original Ext JS documentation of 'Ext.data.validator.IPAddress'
 */
public class IPAddressValidator extends FormatValidator {
  /**
   * @inheritDoc
   */
  public function IPAddressValidator(config:FormatValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A matcher to check for valid IP address. This may be overridden.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.IPAddress.html#cfg-matcher Original Ext JS documentation of 'matcher'
   * @see #getMatcher()
   * @see #setMatcher()
   */
  override public native function get matcher():RegExp;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set matcher(value:RegExp):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid IP address
   * @default 'Is not a valid IP address'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.IPAddress.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  override public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set message(value:String):void;

  /**
   * Returns the value of <code>matcher</code>.
   * @see #matcher
   */
  override public native function getMatcher():RegExp;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  override public native function getMessage():String;

  /**
   * Sets the value of <code>matcher</code>.
   * @param matcher The new value.
   * @see #matcher
   */
  override public native function setMatcher(matcher:RegExp):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  override public native function setMessage(message:String):void;
}
}