package ext.data.validator {

[Native("Ext.data.validator.Inclusion", require)]
/**
 * Validates that the value exists in a →<code>list</code> of values.
 * @see #list
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Inclusion.html Original Ext JS documentation of 'Ext.data.validator.Inclusion'
 */
public class InclusionValidator extends ListValidator {
  /**
   * @param config @inheritDoc
   */
  public function InclusionValidator(config:InclusionValidator = null) {
    super();
  }

  [ExtConfig]
  /**
   * The error message to return when the passed value does not exist
   * in the specified →<code>list</code>.
   * @default 'Is not in the list of acceptable values'
   * @see #list
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Inclusion.html#cfg-message Original Ext JS documentation of 'message'
   */
  public native function get message():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set message(value:String):void;
}
}