package ext.data.validator {

[Native("Ext.data.validator.Length", require)]
/**
 * Validates that the length of the value is between a →<code>min</code> and →<code>max</code>.
 * @see #min
 * @see #max
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Length.html Original Ext JS documentation of 'Ext.data.validator.Length'
 */
public class LengthValidator extends BoundValidator {
  /**
   * @param config @inheritDoc
   */
  public function LengthValidator(config:LengthValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value length is not in the specified
   * range and both the minimum and maximum are specified.
   * @default 'Length must be between {0} and {1}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Length.html#cfg-bothMessage Original Ext JS documentation of 'bothMessage'
   * @see #getBothMessage()
   * @see #setBothMessage()
   */
  override public native function get bothMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set bothMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum length value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Length.html#cfg-max Original Ext JS documentation of 'max'
   * @see #getMax()
   * @see #setMax()
   */
  override public native function get max():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set max(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is more than the maximum
   * length and only a maximum is specified.
   * @default 'Length must be no more than {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Length.html#cfg-maxOnlyMessage Original Ext JS documentation of 'maxOnlyMessage'
   * @see #getMaxOnlyMessage()
   * @see #setMaxOnlyMessage()
   */
  override public native function get maxOnlyMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set maxOnlyMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum length value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Length.html#cfg-min Original Ext JS documentation of 'min'
   * @see #getMin()
   * @see #setMin()
   */
  override public native function get min():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set min(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is less than the minimum
   * length and only a minimum is specified.
   * @default 'Length must be at least {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Length.html#cfg-minOnlyMessage Original Ext JS documentation of 'minOnlyMessage'
   * @see #getMinOnlyMessage()
   * @see #setMinOnlyMessage()
   */
  override public native function get minOnlyMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minOnlyMessage(value:String):void;

  /**
   * Returns the value of <code>bothMessage</code>.
   * @see #bothMessage
   */
  override public native function getBothMessage():String;

  /**
   * Returns the value of <code>max</code>.
   * @see #max
   */
  override public native function getMax():Number;

  /**
   * Returns the value of <code>maxOnlyMessage</code>.
   * @see #maxOnlyMessage
   */
  override public native function getMaxOnlyMessage():String;

  /**
   * Returns the value of <code>min</code>.
   * @see #min
   */
  override public native function getMin():Number;

  /**
   * Returns the value of <code>minOnlyMessage</code>.
   * @see #minOnlyMessage
   */
  override public native function getMinOnlyMessage():String;

  /**
   * Sets the value of <code>bothMessage</code>.
   * @param bothMessage The new value.
   * @see #bothMessage
   */
  override public native function setBothMessage(bothMessage:String):void;

  /**
   * Sets the value of <code>max</code>.
   * @param max The new value.
   * @see #max
   */
  override public native function setMax(max:Number):void;

  /**
   * Sets the value of <code>maxOnlyMessage</code>.
   * @param maxOnlyMessage The new value.
   * @see #maxOnlyMessage
   */
  override public native function setMaxOnlyMessage(maxOnlyMessage:String):void;

  /**
   * Sets the value of <code>min</code>.
   * @param min The new value.
   * @see #min
   */
  override public native function setMin(min:Number):void;

  /**
   * Sets the value of <code>minOnlyMessage</code>.
   * @param minOnlyMessage The new value.
   * @see #minOnlyMessage
   */
  override public native function setMinOnlyMessage(minOnlyMessage:String):void;
}
}