package ext.data.validator {

[Native("Ext.data.validator.List", require)]
/**
 * A superclass for inclusion/exclusion validators.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.List.html Original Ext JS documentation of 'Ext.data.validator.List'
 */
public class ListValidator extends Validator {
  /**
   * @param config @inheritDoc
   */
  public function ListValidator(config:ListValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>. The list to check the passed value against.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.List.html#cfg-list Original Ext JS documentation of 'list'
   * @see #getList()
   * @see #setList()
   */
  public native function get list():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set list(value:Array):void;

  /**
   * Returns the value of <code>list</code>.
   * @see #list
   */
  public native function getList():Array;

  /**
   * Sets the value of <code>list</code>.
   * @param list The new value.
   * @see #list
   */
  public native function setList(list:Array):void;
}
}