package ext.data.validator {

[Native("Ext.data.validator.Number", require)]
/**
 * Validates that the value is a valid number.
 * <p>A valid number may include a leading + or -, comma separators, and a single decimal point.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Number.html Original Ext JS documentation of 'Ext.data.validator.Number'
 */
public class NumberValidator extends Validator {
  /**
   * @inheritDoc
   */
  public function NumberValidator(config:Validator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The decimal separator. Defaults to →<code>ext.util.Format.decimalSeparator</code>.
   * @default undefined
   * @see ext.util.SFormat#decimalSeparator ext.util.Format.decimalSeparator
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Number.html#cfg-decimalSeparator Original Ext JS documentation of 'decimalSeparator'
   * @see #getDecimalSeparator()
   * @see #setDecimalSeparator()
   */
  public native function get decimalSeparator():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set decimalSeparator(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid number.
   * @default 'Is not a valid number'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Number.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set message(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The thousand separator. Defaults to →<code>ext.util.Format.thousandSeparator</code>.
   * @default undefined
   * @see ext.util.SFormat#thousandSeparator ext.util.Format.thousandSeparator
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Number.html#cfg-thousandSeparator Original Ext JS documentation of 'thousandSeparator'
   * @see #getThousandSeparator()
   * @see #setThousandSeparator()
   */
  public native function get thousandSeparator():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set thousandSeparator(value:String):void;

  /**
   * Returns the value of <code>decimalSeparator</code>.
   * @see #decimalSeparator
   */
  public native function getDecimalSeparator():String;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  public native function getMessage():String;

  /**
   * Returns the value of <code>thousandSeparator</code>.
   * @see #thousandSeparator
   */
  public native function getThousandSeparator():String;

  /**
   * Sets the value of <code>decimalSeparator</code>.
   * @param decimalSeparator The new value.
   * @see #decimalSeparator
   */
  public native function setDecimalSeparator(decimalSeparator:String):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  public native function setMessage(message:String):void;

  /**
   * Sets the value of <code>thousandSeparator</code>.
   * @param thousandSeparator The new value.
   * @see #thousandSeparator
   */
  public native function setThousandSeparator(thousandSeparator:String):void;
}
}