package ext.data.validator {

[Native("Ext.data.validator.Phone", require)]
/**
 * Validates that the value is a valid phone.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Phone.html Original Ext JS documentation of 'Ext.data.validator.Phone'
 */
public class PhoneValidator extends FormatValidator {
  /**
   * @inheritDoc
   */
  public function PhoneValidator(config:FormatValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A matcher to check for simple phones. This may be overridden.
   * @default new RegExp('^ &#42;' + // optional country code
   * '(?:' + '\\+?' + // maybe + prefix
   * '(\\d{1,3})' + // optional separator
   * '[- .]?' + ')?' + // optional area code
   * '(?:' + '(?:' + '(\\d{3})' + // without ()
   * '|' + '\\((\\d{3})\\)' + // with ()
   * ')?' + // optional separator
   * '[- .]?' + ')' + // CO code (3 digit prefix)
   * '(?:' + '([2-9]\\d{2})' + // optional separator
   * '[- .]?' + ')' + // line number (4 digits)
   * '(\\d{4})' + // optional extension
   * '(?: &#42;(?:e?xt?) &#42;(\\d&#42;))?' + ' &#42;$')
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Phone.html#cfg-matcher Original Ext JS documentation of 'matcher'
   * @see #getMatcher()
   * @see #setMatcher()
   */
  override public native function get matcher():RegExp;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set matcher(value:RegExp):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid phone.
   * @default 'Is not a valid phone number'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Phone.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  override public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set message(value:String):void;

  /**
   * Returns the value of <code>matcher</code>.
   * @see #matcher
   */
  override public native function getMatcher():RegExp;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  override public native function getMessage():String;

  /**
   * Sets the value of <code>matcher</code>.
   * @param matcher The new value.
   * @see #matcher
   */
  override public native function setMatcher(matcher:RegExp):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  override public native function setMessage(message:String):void;
}
}