package ext.data.validator {

[Native("Ext.data.validator.Presence", require)]
/**
 * Validates that the passed value is not <code>null</code> or <code>undefined</code> or <code>''</code>.
 * An empty string may be allowed with →<code>allowEmpty</code>.
 * @see #allowEmpty
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Presence.html Original Ext JS documentation of 'Ext.data.validator.Presence'
 */
public class PresenceValidator extends Validator {
  /**
   * @param config @inheritDoc
   */
  public function PresenceValidator(config:PresenceValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to allow <code>''</code> as a valid value.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Presence.html#cfg-allowEmpty Original Ext JS documentation of 'allowEmpty'
   * @see #getAllowEmpty()
   * @see #setAllowEmpty()
   */
  public native function get allowEmpty():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set allowEmpty(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not specified.
   * @default 'Must be present'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Presence.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set message(value:String):void;

  /**
   * Returns the value of <code>allowEmpty</code>.
   * @see #allowEmpty
   */
  public native function getAllowEmpty():Boolean;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  public native function getMessage():String;

  /**
   * Sets the value of <code>allowEmpty</code>.
   * @param allowEmpty The new value.
   * @see #allowEmpty
   */
  public native function setAllowEmpty(allowEmpty:Boolean):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  public native function setMessage(message:String):void;
}
}