package ext.data.validator {

[Native("Ext.data.validator.Range", require)]
/**
 * Validates that the the value is between a →<code>min</code> and →<code>max</code>.
 * @see #min
 * @see #max
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Range.html Original Ext JS documentation of 'Ext.data.validator.Range'
 */
public class RangeValidator extends BoundValidator {
  /**
   * @param config @inheritDoc
   */
  public function RangeValidator(config:RangeValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not in the specified range
   * and both the minimum and maximum are specified.
   * @default 'Must be between {0} and {1}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Range.html#cfg-bothMessage Original Ext JS documentation of 'bothMessage'
   * @see #getBothMessage()
   * @see #setBothMessage()
   */
  override public native function get bothMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set bothMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Range.html#cfg-max Original Ext JS documentation of 'max'
   * @see #getMax()
   * @see #setMax()
   */
  override public native function get max():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set max(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is more than the maximum
   * and only a maximum is specified.
   * @default 'Must be no more than than {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Range.html#cfg-maxOnlyMessage Original Ext JS documentation of 'maxOnlyMessage'
   * @see #getMaxOnlyMessage()
   * @see #setMaxOnlyMessage()
   */
  override public native function get maxOnlyMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set maxOnlyMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Range.html#cfg-min Original Ext JS documentation of 'min'
   * @see #getMin()
   * @see #setMin()
   */
  override public native function get min():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set min(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is less than the minimum
   * and only a minimum is specified.
   * @default 'Must be at least {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Range.html#cfg-minOnlyMessage Original Ext JS documentation of 'minOnlyMessage'
   * @see #getMinOnlyMessage()
   * @see #setMinOnlyMessage()
   */
  override public native function get minOnlyMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minOnlyMessage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not numeric.
   * @default 'Must be numeric'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Range.html#cfg-nanMessage Original Ext JS documentation of 'nanMessage'
   * @see #getNanMessage()
   * @see #setNanMessage()
   */
  public native function get nanMessage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set nanMessage(value:String):void;

  /**
   * Returns the value of <code>bothMessage</code>.
   * @see #bothMessage
   */
  override public native function getBothMessage():String;

  /**
   * Returns the value of <code>max</code>.
   * @see #max
   */
  override public native function getMax():Number;

  /**
   * Returns the value of <code>maxOnlyMessage</code>.
   * @see #maxOnlyMessage
   */
  override public native function getMaxOnlyMessage():String;

  /**
   * Returns the value of <code>min</code>.
   * @see #min
   */
  override public native function getMin():Number;

  /**
   * Returns the value of <code>minOnlyMessage</code>.
   * @see #minOnlyMessage
   */
  override public native function getMinOnlyMessage():String;

  /**
   * Returns the value of <code>nanMessage</code>.
   * @see #nanMessage
   */
  public native function getNanMessage():String;

  /**
   * Sets the value of <code>bothMessage</code>.
   * @param bothMessage The new value.
   * @see #bothMessage
   */
  override public native function setBothMessage(bothMessage:String):void;

  /**
   * Sets the value of <code>max</code>.
   * @param max The new value.
   * @see #max
   */
  override public native function setMax(max:Number):void;

  /**
   * Sets the value of <code>maxOnlyMessage</code>.
   * @param maxOnlyMessage The new value.
   * @see #maxOnlyMessage
   */
  override public native function setMaxOnlyMessage(maxOnlyMessage:String):void;

  /**
   * Sets the value of <code>min</code>.
   * @param min The new value.
   * @see #min
   */
  override public native function setMin(min:Number):void;

  /**
   * Sets the value of <code>minOnlyMessage</code>.
   * @param minOnlyMessage The new value.
   * @see #minOnlyMessage
   */
  override public native function setMinOnlyMessage(minOnlyMessage:String):void;

  /**
   * Sets the value of <code>nanMessage</code>.
   * @param nanMessage The new value.
   * @see #nanMessage
   */
  public native function setNanMessage(nanMessage:String):void;
}
}