package ext.data.validator {

[Native("Ext.data.validator.Url", require)]
/**
 * Validates that the value is a proper URL.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Url.html Original Ext JS documentation of 'Ext.data.validator.Url'
 */
public class UrlValidator extends FormatValidator {
  /**
   * @inheritDoc
   */
  public function UrlValidator(config:FormatValidator = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A matcher to check for simple Urls. This may be overridden.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Url.html#cfg-matcher Original Ext JS documentation of 'matcher'
   * @see #getMatcher()
   * @see #setMatcher()
   */
  override public native function get matcher():RegExp;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set matcher(value:RegExp):void;

  [ExtConfig]
  [Bindable]
  /**
   * The error message to return when the value is not a valid URL.
   * @default 'Is not a valid URL'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Url.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  override public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set message(value:String):void;

  /**
   * Returns the value of <code>matcher</code>.
   * @see #matcher
   */
  override public native function getMatcher():RegExp;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  override public native function getMessage():String;

  /**
   * Sets the value of <code>matcher</code>.
   * @param matcher The new value.
   * @see #matcher
   */
  override public native function setMatcher(matcher:RegExp):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  override public native function setMessage(message:String):void;
}
}