package ext.data.validator {
import ext.Base;
import ext.data.Model;
import ext.mixin.IFactoryable;

[Native("Ext.data.validator.Validator", require)]
/**
 * The base class for validators to be used to validate <i>fields</i> (→<code>ext.data.field.DataField</code>) in
 * a <i>model</i> (→<code>ext.data.Model</code>).
 * <p>The model will call the →<code>validate()</code> method, which may be overridden by subclasses.</p>
 * @see ext.data.field.DataField
 * @see ext.data.Model
 * @see #validate()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Validator.html Original Ext JS documentation of 'Ext.data.validator.Validator'
 */
public class Validator extends Base implements IFactoryable {
  /**
   * Creates new Validator.
   * @param config A config object. A function may also be passed,
   * which will be used as the →<code>validate()</code> method for this validator.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Validator.html#method-constructor Original Ext JS documentation of 'constructor'
   * @see #validate()
   */
  public function Validator(config:Validator = null) {
    super();
  }

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * A string representation of this format.
   * @default 'base'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Validator.html#property-type Original Ext JS documentation of 'type'
   */
  public native function get type():String;

  /**
   * @private
   */
  public native function set type(value:String):void;

  /**
   * Validates the passed value.
   * @param value The value
   * @param record The record
   * @return <code>true</code> if the value is valid. A string may be returned if the value
   * is not valid, to indicate an error message. Any other non <code>true</code> value indicates the value
   * is not valid.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.validator.Validator.html#method-validate Original Ext JS documentation of 'validate'
   */
  public native function validate(value:Object, record:Model):*;
}
}