package ext.data.virtual {
import ext.data.DataRange;

[Native("Ext.data.virtual.Range", require)]
/**
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Range.html Original Ext JS documentation of 'Ext.data.virtual.Range'
 */
public class VirtualDataRange extends DataRange {
  [ExtConfig]
  /**
   * The callback to call when new records in this range become available.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Range.html#cfg-callback Original Ext JS documentation of 'callback'
   */
  public native function get callback():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set callback(value:*):void;

  [ExtConfig]
  /**
   * The number of records to fetch beyond the active range in the direction of movement.
   * If the range is advancing forward, the additional records are beyond <code>→end</code>. If
   * advancing backwards, they are before <code>→begin</code>.
   * @see #end
   * @see #begin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Range.html#cfg-leadingBufferZone Original Ext JS documentation of 'leadingBufferZone'
   */
  public native function get leadingBufferZone():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set leadingBufferZone(value:Number):void;

  [ExtConfig]
  /**
   * Specify <code>true</code> to enable prefetching for this range.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Range.html#cfg-prefetch Original Ext JS documentation of 'prefetch'
   */
  public native function get prefetch():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set prefetch(value:Boolean):void;

  [ExtConfig]
  /**
   * The object that implements the supplied <code>→callback</code> method.
   * @see #callback
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Range.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * The number of records to fetch beyond the active trailing the direction of movement.
   * If the range is advancing forward, the additional records are before <code>→begin</code>. If
   * advancing backwards, they are beyond <code>→end</code>.
   * @see #begin
   * @see #end
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Range.html#cfg-trailingBufferZone Original Ext JS documentation of 'trailingBufferZone'
   */
  public native function get trailingBufferZone():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trailingBufferZone(value:Number):void;
}
}