package ext.data.virtual {
import ext.data.DataRange;
import ext.data.Model;
import ext.data.ProxyStore;

[Native("Ext.data.virtual.Store", require)]
/**
 * This type of store is a replacement for BufferedStore at least for Modern. The primary
 * use of this store is to create and manage "active ranges" of records.
 * <p>For example:</p>
 * <pre>
 *  var range = store.createActiveRange({
 *      begin: 100,
 *      end: 200,
 *      prefetch: true,  // allow prefetching beyond range
 *      callback: 'onRangeUpdate',
 *      scope: this
 *  });
 *
 *  // Navigate to a different range. This will causes pages to load and
 *  // the onRangeUpdate method will be called as the load(s) progress.
 *  // This can change the length or number of records spanned on each
 *  // call.
 *  //
 *  range.goto(300, 400);
 *
 *  onRangeUpdate: function (range, begin, end) {
 *      // Called when records appear in the range...
 *      // We can check if all things are loaded:
 *
 *      // Or we can use range.records (sparsely populated)
 *  }
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html Original Ext JS documentation of 'Ext.data.virtual.Store'
 */
public class VirtualStore extends ProxyStore {
  /**
   * @inheritDoc
   */
  public function VirtualStore(config:ProxyStore = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The number of records to fetch beyond the active range in the direction of
   * movement. If the range is advancing forward, the additional records are beyond
   * <code>end</code>. If advancing backwards, they are before <code>begin</code>.
   * @default 200
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#cfg-leadingBufferZone Original Ext JS documentation of 'leadingBufferZone'
   * @see #getLeadingBufferZone()
   * @see #setLeadingBufferZone()
   */
  public native function get leadingBufferZone():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set leadingBufferZone(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to defer any filtering operation to the server. If <code>false</code>, filtering is done
   * locally on the client.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#cfg-remoteFilter Original Ext JS documentation of 'remoteFilter'
   * @see #getRemoteFilter()
   * @see #setRemoteFilter()
   */
  override public native function get remoteFilter():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set remoteFilter(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if the sorting should be performed on the server side, false if it is local only.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#cfg-remoteSort Original Ext JS documentation of 'remoteSort'
   * @see #getRemoteSort()
   * @see #setRemoteSort()
   */
  override public native function get remoteSort():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set remoteSort(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * If true, any sorters attached to this Store will be run after loading data,
   * before the datachanged event is fired. Defaults to true, ignored if
   * →<code>ext.data.Store.remoteSort</code> is true
   * @default false
   * @see ext.data.Store#remoteSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#cfg-sortOnLoad Original Ext JS documentation of 'sortOnLoad'
   * @see #getSortOnLoad()
   * @see #setSortOnLoad()
   */
  override public native function get sortOnLoad():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set sortOnLoad(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This config controls whether removed records are remembered by this store for
   * later saving to the server.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#cfg-trackRemoved Original Ext JS documentation of 'trackRemoved'
   * @see #getTrackRemoved()
   * @see #setTrackRemoved()
   */
  override public native function get trackRemoved():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set trackRemoved(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of records to fetch beyond the active trailing the direction of
   * movement. If the range is advancing forward, the additional records are before
   * <code>begin</code>. If advancing backwards, they are beyond <code>end</code>.
   * @default 50
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#cfg-trailingBufferZone Original Ext JS documentation of 'trailingBufferZone'
   * @see #getTrailingBufferZone()
   * @see #setTrailingBufferZone()
   */
  public native function get trailingBufferZone():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set trailingBufferZone(value:Number):void;

  /**
   * Checks if a record is in the current active data set.
   * @param record The record
   * @return <code>true</code> if the record is in the current active data set.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#method-contains Original Ext JS documentation of 'contains'
   */
  override public native function contains(record:Model):Boolean;

  /**
   * Create a <code>Range</code> instance to access records by their index.
   * @since 6.5.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#method-createActiveRange Original Ext JS documentation of 'createActiveRange'
   */
  override public native function createActiveRange(config:* = undefined):DataRange;

  /**
   * Get the Record at the specified index.
   * <p>The index is effected by filtering.</p>
   * @param index The index of the Record to find.
   * @return The Record at the passed index. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#method-getAt Original Ext JS documentation of 'getAt'
   */
  override public native function getAt(index:Number):Model;

  /**
   * Get the Record with the specified id.
   * <p>This method is not affected by filtering, lookup will be performed from all records
   * inside the store, filtered or not.</p>
   * @param id The id of the Record to find.
   * @return The Record with the passed id. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#method-getById Original Ext JS documentation of 'getById'
   */
  override public native function getById(id:*):Model;

  /**
   * Returns the value of <code>leadingBufferZone</code>.
   * @see #leadingBufferZone
   */
  public native function getLeadingBufferZone():Number;

  /**
   * Returns the value of <code>remoteFilter</code>.
   * @see #remoteFilter
   */
  override public native function getRemoteFilter():Boolean;

  /**
   * Returns the value of <code>remoteSort</code>.
   * @see #remoteSort
   */
  override public native function getRemoteSort():Boolean;

  /**
   * Returns the value of <code>sortOnLoad</code>.
   * @see #sortOnLoad
   */
  override public native function getSortOnLoad():Boolean;

  /**
   * Returns the value of <code>trackRemoved</code>.
   * @see #trackRemoved
   */
  override public native function getTrackRemoved():Boolean;

  /**
   * Returns the value of <code>trailingBufferZone</code>.
   * @see #trailingBufferZone
   */
  public native function getTrailingBufferZone():Number;

  /**
   * Get the index of the record within the virtual store. Because virtual stores only
   * load a partial set of records, not all records in the logically matching set will
   * have been loaded and will therefore return -1.
   * @param record The record to find.
   * @return The index of the <code>record</code> or -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(record:Model):Number;

  /**
   * Get the index within the store of the record with the passed id. Because virtual
   * stores only load a partial set of records, not all records in the logically
   * matching set will have been loaded and will therefore return -1.
   * @param id The id of the record to find.
   * @return The index of the record or -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#method-indexOfId Original Ext JS documentation of 'indexOfId'
   */
  public native function indexOfId(id:String):Number;

  /**
   * Returns <code>true</code> if the store has been loaded.
   * @return <code>true</code> if the store has been loaded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.virtual.Store.html#method-isLoaded Original Ext JS documentation of 'isLoaded'
   */
  override public native function isLoaded():Boolean;

  /**
   * Sets the value of <code>leadingBufferZone</code>.
   * @param leadingBufferZone The new value.
   * @see #leadingBufferZone
   */
  public native function setLeadingBufferZone(leadingBufferZone:Number):void;

  /**
   * Sets the value of <code>remoteFilter</code>.
   * @param remoteFilter The new value.
   * @see #remoteFilter
   */
  override public native function setRemoteFilter(remoteFilter:Boolean):void;

  /**
   * Sets the value of <code>remoteSort</code>.
   * @param remoteSort The new value.
   * @see #remoteSort
   */
  override public native function setRemoteSort(remoteSort:Boolean):void;

  /**
   * Sets the value of <code>sortOnLoad</code>.
   * @param sortOnLoad The new value.
   * @see #sortOnLoad
   */
  override public native function setSortOnLoad(sortOnLoad:Boolean):void;

  /**
   * Sets the value of <code>trackRemoved</code>.
   * @param trackRemoved The new value.
   * @see #trackRemoved
   */
  override public native function setTrackRemoved(trackRemoved:Boolean):void;

  /**
   * Sets the value of <code>trailingBufferZone</code>.
   * @param trailingBufferZone The new value.
   * @see #trailingBufferZone
   */
  public native function setTrailingBufferZone(trailingBufferZone:Number):void;
}
}