package ext.data.writer {
import ext.Base;
import ext.data.Model;
import ext.data.Request;
import ext.data.operation.Operation;
import ext.mixin.IFactoryable;

[Native("Ext.data.writer.Writer", require)]
/**
 * Base Writer class used by most subclasses of →<code>ext.data.proxy.ServerProxy</code>. This class
 * is responsible for taking a set of →<code>ext.data.operation.Operation</code> objects and a
 * →<code>ext.data.Request</code> object and modifying that request based on the Operations.
 * <p>For example a Ext.data.writer.Json would format the Operations and their
 * →<code>ext.data.Model</code> instances based on the config options passed to the JsonWriter's
 * constructor.</p>
 * <p>Writers are not needed for any kind of local storage - whether via a
 * <i>Web Storage proxy</i> (→<code>ext.data.proxy.WebStorageProxy</code>) (see
 * <i>localStorage</i> (→<code>ext.data.proxy.LocalStorageProxy</code>) and
 * <i>sessionStorage</i> (→<code>ext.data.proxy.SessionStorageProxy</code>))
 * or just in memory via a →<code>ext.data.proxy.MemoryProxy</code>.</p>
 * <p><b>Dates</b></p>
 * <p>Before sending dates to the server, they can be formatted using an →<code>ext.DateUtil</code>
 * format. These formats can be specified both on the field and the writer itself. In terms
 * of precedence, from highest to lowest:</p>
 * <ul>
 * <li><i>Writer.dateFormat</i> (→<code>dateFormat</code>) The writer <code>→dateFormat</code> will always have the
 * highest precedence.</li>
 * <li>→<code>ext.data.field.DateDataField.dateWriteFormat</code> The <code>dateWriteFormat</code> given to the field
 * instance. This is handled by →<code>ext.data.field.DateDataField.serialize()</code>.</li>
 * <li><i>Field.dateFormat</i> (→<code>ext.data.field.DateDataField.dateFormat</code>) This is handled by the field's
 * <code>serialize</code> method.</li>
 * <li><i>Field.dateReadFormat</i> (→<code>ext.data.field.DateDataField.dateReadFormat</code>) Also handled by the
 * field's <code>serialize</code> method.</li>
 * </ul>
 * @see ext.data.proxy.ServerProxy
 * @see ext.data.operation.Operation
 * @see ext.data.Request
 * @see ext.data.Model
 * @see ext.data.proxy.WebStorageProxy
 * @see ext.data.proxy.LocalStorageProxy
 * @see ext.data.proxy.SessionStorageProxy
 * @see ext.data.proxy.MemoryProxy
 * @see ext.#DateUtil ext.DateUtil
 * @see #dateFormat
 * @see ext.data.field.DateDataField#dateWriteFormat
 * @see ext.data.field.DateDataField#serialize()
 * @see ext.data.field.DateDataField#dateFormat
 * @see ext.data.field.DateDataField#dateReadFormat
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html Original Ext JS documentation of 'Ext.data.writer.Writer'
 */
public class DataWriter extends Base implements IFactoryable {
  /**
   * Creates new Writer.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DataWriter(config:DataWriter = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * This object contains the options passed to <code>→ext.data.Model.getData()</code> when
   * writing <code>→ext.data.Model.phantom</code> records or when <code>→writeAllFields</code> is set
   * to <code>true</code>.
   * <p><i>NOTE:</i> The <code>serialize</code> option cannot be used here.</p>
   * @default {
   *     persist: true
   * }
   * @see ext.data.Model#getData()
   * @see ext.data.Model#phantom
   * @see #writeAllFields
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-allDataOptions Original Ext JS documentation of 'allDataOptions'
   * @see #getAllDataOptions()
   * @see #setAllDataOptions()
   */
  public native function get allDataOptions():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set allDataOptions(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * When specified this property causes the <code>→ext.data.Model.idProperty</code> of
   * newly created records to be sent to the server as this name instead of the
   * value of the <code>idProperty</code>.
   * <p>For example, by default, the following code:</p>
   * <pre>
   *  Ext.define('Person', {
   *      idProperty: 'id',  // this is the default value (for clarity)
   *
   *      fields: [ 'name' ]
   *  });
   *
   *  var person = new Person({
   *      // no id provided, so one is generated
   *      name: 'Clark Kent'
   *  });
   * </pre>
   * <p>Will send this to the server:</p>
   * <pre>
   *  {
   *      id: 'Person-1',
   *      name: 'Clark Kent'
   *  }
   * </pre>
   * <p>This can be an issue if the server expects an integer for the "id" property.
   * You can use <code>→ext.data.Model.identifier</code> to produce identifiers that
   * the server would recognize or use this config to send the client's id in a
   * different property.</p>
   * <pre>
   *  Ext.define('Person', {
   *      idProperty: 'id',  // this is the default value (for clarity)
   *
   *      proxy: {
   *          writer: {
   *              clientIdProperty: 'clientId'
   *          }
   *      },
   *
   *      fields: [ 'name' ]
   *  });
   * </pre>
   * <p>Given the above, the server is sent this data now:</p>
   * <pre>
   *  {
   *      clientId: 'Person-1',
   *      name: 'Clark Kent'
   *  }
   * </pre>
   * <p>While this config provides the behavior of <code>→ext.data.Model.clientIdProperty</code>
   * from previous releases, this property is not as useful as a suitable
   * <code>→ext.data.Model.identifier</code> due to id's appearing in foreign-key fields
   * and in <code>→ext.data.Model.manyToMany</code> associations.</p>
   * <p>See <code>→ext.data.Model.identifier</code> for more on id generation.</p>
   * @see ext.data.Model#idProperty
   * @see ext.data.Model#identifier
   * @see ext.data.Model#clientIdProperty
   * @see ext.data.Model#manyToMany
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-clientIdProperty Original Ext JS documentation of 'clientIdProperty'
   * @see #getClientIdProperty()
   * @see #setClientIdProperty()
   */
  public native function get clientIdProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set clientIdProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This is used for each field of type date in the model to format the value before
   * it is sent to the server.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-dateFormat Original Ext JS documentation of 'dateFormat'
   * @see #getDateFormat()
   * @see #setDateFormat()
   */
  public native function get dateFormat():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dateFormat(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * <code>true</code> to identify an object as an instance of this class, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#property-isWriter Original Ext JS documentation of 'isWriter'
   */
  public native function get isWriter():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * This property is used to read the key for each value that will be sent to the
   * server.
   * <p>For example:</p>
   * <pre>
   * Ext.define('Person', {
   *     extend: 'Ext.data.Model',
   *     fields: [{
   *         name: 'first',
   *         mapping: 'firstName'
   *     }, {
   *         name: 'last',
   *         mapping: 'lastName'
   *     }, {
   *         name: 'age'
   *     }]
   * });
   *
   * new Ext.data.writer.Writer({
   *     nameProperty: 'mapping'
   * });
   *
   * // This will be sent to the server
   * {
   *     firstName: 'first name value',
   *     lastName: 'last name value',
   *     age: 1
   * }
   * </pre>
   * <p>If the value is not present, the field name will always be used.</p>
   * @default 'name'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-nameProperty Original Ext JS documentation of 'nameProperty'
   * @see #getNameProperty()
   * @see #setNameProperty()
   */
  public native function get nameProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set nameProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object contains the options passed to <code>→ext.data.Model.getData()</code> when
   * writing non <code>→ext.data.Model.phantom</code> records or when <code>→writeAllFields</code> is
   * set to <code>false</code>.
   * <p><i>NOTE:</i> The <code>serialize</code> option cannot be used here.</p>
   * @default {
   *     changes: true,
   *     critical: true
   * }
   * @see ext.data.Model#getData()
   * @see ext.data.Model#phantom
   * @see #writeAllFields
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-partialDataOptions Original Ext JS documentation of 'partialDataOptions'
   * @see #getPartialDataOptions()
   * @see #setPartialDataOptions()
   */
  public native function get partialDataOptions():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set partialDataOptions(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * If a transform function is set, it will be invoked just before →<code>writeRecords()</code>
   * executes. It is passed the unserialized data object and the
   * <i>request</i> (→<code>ext.data.Request</code>) object. The transform function returns a data object,
   * which can be a modified version of the original data object, or a completely new data
   * object. The transform can be a function, or an object with a 'fn' key and an optional
   * 'scope' key. Example usage:
   * <pre>
   * Ext.create('Ext.data.Store', {
   *     model: 'User',
   *     proxy: {
   *         type: 'ajax',
   *         url : 'users.json',
   *         writer: {
   *             type: 'json',
   *             transform: {
   *                 fn: function(data, request) {
   *                     // do some manipulation of the unserialized data object
   *                     return data;
   *                 },
   *                 scope: this
   *             }
   *         }
   *     },
   * });
   * </pre>
   * @default null
   * @see #writeRecords()
   * @see ext.data.Request
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-transform Original Ext JS documentation of 'transform'
   * @see #getTransform()
   * @see #setTransform()
   */
  public native function get transform():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set transform(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to write all fields from the record to the
   * server. If set to <code>false</code> it will only send the fields that were modified. Note
   * that any fields that have <code>→ext.data.field.DataField.persist</code> set to <code>false</code>
   * will still be ignored while those with <code>→ext.data.field.DataField.critical</code>
   * set to <code>true</code> will be included.
   * <p>The exact set of fields written is determined by <code>→allDataOptions</code> (when <code>true</code>)
   * or <code>→partialDataOptions</code> (when <code>false</code>). This option is ignored and treated as
   * <code>true</code> when writing <code>→ext.data.Model.phantom</code> records.</p>
   * <p>It is seldom a good idea to use this config. Rather use <code>→allDataOptions</code> or
   * <code>→partialDataOptions</code> to control what fields are sent for records based on their
   * <code>→ext.data.Model.phantom</code> state.</p>
   * <p>In the previous release, this was default <code>true</code>.</p>
   * @default false
   * @see ext.data.field.DataField#persist
   * @see ext.data.field.DataField#critical
   * @see #allDataOptions
   * @see #partialDataOptions
   * @see ext.data.Model#phantom
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-writeAllFields Original Ext JS documentation of 'writeAllFields'
   * @see #getWriteAllFields()
   * @see #setWriteAllFields()
   */
  public native function get writeAllFields():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set writeAllFields(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * By default, each record's id is always included in the output for non-phantom
   * records since in most cases the id will be required on the server to process
   * the record action. This is helpful since the id will normally not be modified,
   * and so would not be sent to the server unless →<code>writeAllFields</code> was
   * explicitly enabled.
   * <p>However, there are cases where it is not desirable for the record id to be passed
   * in the data directly. For example, when using a RESTful API the record id would
   * typically be appended to the url instead.</p>
   * @default true
   * @see #writeAllFields
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#cfg-writeRecordId Original Ext JS documentation of 'writeRecordId'
   * @see #getWriteRecordId()
   * @see #setWriteRecordId()
   */
  public native function get writeRecordId():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set writeRecordId(value:Boolean):void;

  /**
   * Returns the value of <code>allDataOptions</code>.
   * @see #allDataOptions
   */
  public native function getAllDataOptions():Object;

  /**
   * Returns the value of <code>clientIdProperty</code>.
   * @see #clientIdProperty
   */
  public native function getClientIdProperty():String;

  /**
   * Returns the value of <code>dateFormat</code>.
   * @see #dateFormat
   */
  public native function getDateFormat():String;

  /**
   * Returns the value of <code>nameProperty</code>.
   * @see #nameProperty
   */
  public native function getNameProperty():String;

  /**
   * Returns the value of <code>partialDataOptions</code>.
   * @see #partialDataOptions
   */
  public native function getPartialDataOptions():Object;

  /**
   * Formats the data for each record before sending it to the server. This method should
   * be overridden to format the data in a way that differs from the default.
   * @param record The record that we are writing to the server.
   * @param operation An operation object.
   * @return An object of name/value keys to be written to the server.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#method-getRecordData Original Ext JS documentation of 'getRecordData'
   */
  public native function getRecordData(record:Model, operation:Operation = null):Object;

  /**
   * Returns the value of <code>transform</code>.
   * @see #transform
   */
  public native function getTransform():*;

  /**
   * Returns the value of <code>writeAllFields</code>.
   * @see #writeAllFields
   */
  public native function getWriteAllFields():Boolean;

  /**
   * Returns the value of <code>writeRecordId</code>.
   * @see #writeRecordId
   */
  public native function getWriteRecordId():Boolean;

  /**
   * Sets the value of <code>allDataOptions</code>.
   * @param allDataOptions The new value.
   * @see #allDataOptions
   */
  public native function setAllDataOptions(allDataOptions:Object):void;

  /**
   * Sets the value of <code>clientIdProperty</code>.
   * @param clientIdProperty The new value.
   * @see #clientIdProperty
   */
  public native function setClientIdProperty(clientIdProperty:String):void;

  /**
   * Sets the value of <code>dateFormat</code>.
   * @param dateFormat The new value.
   * @see #dateFormat
   */
  public native function setDateFormat(dateFormat:String):void;

  /**
   * Sets the value of <code>nameProperty</code>.
   * @param nameProperty The new value.
   * @see #nameProperty
   */
  public native function setNameProperty(nameProperty:String):void;

  /**
   * Sets the value of <code>partialDataOptions</code>.
   * @param partialDataOptions The new value.
   * @see #partialDataOptions
   */
  public native function setPartialDataOptions(partialDataOptions:Object):void;

  /**
   * Sets the value of <code>transform</code>.
   * @param transform The new value.
   * @see #transform
   */
  public native function setTransform(transform:*):void;

  /**
   * Sets the value of <code>writeAllFields</code>.
   * @param writeAllFields The new value.
   * @see #writeAllFields
   */
  public native function setWriteAllFields(writeAllFields:Boolean):void;

  /**
   * Sets the value of <code>writeRecordId</code>.
   * @param writeRecordId The new value.
   * @see #writeRecordId
   */
  public native function setWriteRecordId(writeRecordId:Boolean):void;

  /**
   * Prepares a Proxy's Ext.data.Request object.
   * @param request The request object.
   * @return The modified request object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#method-write Original Ext JS documentation of 'write'
   */
  public native function write(request:Request):Request;

  /**
   * Write the record data to the request in the appropriate format.
   * @param request The request.
   * @param data An array of objects containing data.
   * @return The request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Writer.html#method-writeRecords Original Ext JS documentation of 'writeRecords'
   */
  protected native function writeRecords(request:Request, data:Array):Request;
}
}