package ext.data.writer {

[Native("Ext.data.writer.Json", require)]
/**
 * This class is used to write →<code>ext.data.Model</code> data to the server in a JSON format.
 * The →<code>allowSingle</code> configuration can be set to false to force the records to always
 * be encoded in an array, even if there is only a single record being sent.
 * @see ext.data.Model
 * @see #allowSingle
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Json.html Original Ext JS documentation of 'Ext.data.writer.Json'
 */
public class JsonWriter extends DataWriter {
  /**
   * @param config @inheritDoc
   */
  public function JsonWriter(config:JsonWriter = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Configure with <code>false</code> to ensure that records are
   * always wrapped in an array, even if there is only one record being sent. When there
   * is more than one record, they will always be encoded into an array.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Json.html#cfg-allowSingle Original Ext JS documentation of 'allowSingle'
   * @see #getAllowSingle()
   * @see #setAllowSingle()
   */
  public native function get allowSingle():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set allowSingle(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configure <code>true</code> to send record data (all record fields
   * if →<code>writeAllFields</code> is <code>true</code>) as a JSON encoded HTTP parameter named by the
   * →<code>rootProperty</code> configuration.
   * <p>The encode option should only be set to true when a →<code>rootProperty</code> is defined,
   * because the values will be sent as part of the request parameters as opposed to
   * a raw post. The root will be the name of the parameter sent to the server.</p>
   * @default false
   * @see #writeAllFields
   * @see #rootProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Json.html#cfg-encode Original Ext JS documentation of 'encode'
   * @see #getEncode()
   * @see #setEncode()
   */
  public native function get encode():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set encode(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * By default, when dot-delimited field
   * <i>mappings</i> (→<code>nameProperty</code>) are used (e.g. <code>name: 'myProperty', mapping: 'my.nested.property'</code>) the writer will simply output a flat data object containing
   * the mapping string literal as the property name (e.g. <code>{ 'my.nested.property': 'foo' }</code>).
   * <p>Mappings are used to map incoming nested JSON to flat Ext models. In many case, the data
   * output by the writer should preferrably match the original nested data format. Setting
   * this config to <code>true</code> will ensure that the output will instead look like
   * <code>{ my: { nested: { property: 'foo' }}}</code>. The output is generated by
   * →<code>getExpandedData()</code>, which can optionally be overridden to apply
   * more customized logic.</p>
   * @default false
   * @see #nameProperty
   * @see #getExpandedData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Json.html#cfg-expandData Original Ext JS documentation of 'expandData'
   * @see #getExpandData()
   * @see #setExpandData()
   */
  public native function get expandData():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set expandData(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The HTTP parameter name by which JSON encoded records
   * will be passed to the server if the →<code>encode</code> option is <code>true</code>.
   * @default undefined
   * @see #encode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Json.html#cfg-rootProperty Original Ext JS documentation of 'rootProperty'
   * @see #getRootProperty()
   * @see #setRootProperty()
   */
  public native function get rootProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rootProperty(value:String):void;

  /**
   * Returns the value of <code>allowSingle</code>.
   * @see #allowSingle
   */
  public native function getAllowSingle():Boolean;

  /**
   * Returns the value of <code>encode</code>.
   * @see #encode
   */
  public native function getEncode():Boolean;

  /**
   * Returns the value of <code>expandData</code>.
   * @see #expandData
   */
  public native function getExpandData():Boolean;

  /**
   * The Reader classes support dot-delimited data mappings for extracting nested raw data
   * into fields, so the writer must support converting the flat →<code>ext.data.Model</code> structure
   * back into the original nested data format. Using the same mappings when available, the Writer
   * will simply split each delimiter into a nested object in the output, which should exactly
   * match the input format. For example, record data like this:
   * <pre>
   * my.nested.property: 'foo',
   * my.nested.another: 'bar',
   * my.somethingElse: 123
   * </pre>
   * <p>should write out as...</p>
   * <pre>
   * my: {
   *     nested: {
   *         property: 'foo',
   *         another: 'bar
   *     },
   *     somethingElse: 123
   * }
   * </pre>
   * <p>This behavior is governed by the →<code>expandData</code> config. By default, this option is
   * <code>false</code> for compatibility reasons, and will output a flat structure matching the flat record
   * format. Setting this config to <code>true</code> will enable the expanded mapping behavior as shown
   * here. This method could also be overridden to provide an even more customized output data
   * structure.</p>
   * @see ext.data.Model
   * @see #expandData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Json.html#method-getExpandedData Original Ext JS documentation of 'getExpandedData'
   */
  protected native function getExpandedData(data:*):Object;

  /**
   * Returns the value of <code>rootProperty</code>.
   * @see #rootProperty
   */
  public native function getRootProperty():String;

  /**
   * Sets the value of <code>allowSingle</code>.
   * @param allowSingle The new value.
   * @see #allowSingle
   */
  public native function setAllowSingle(allowSingle:Boolean):void;

  /**
   * Sets the value of <code>encode</code>.
   * @param encode The new value.
   * @see #encode
   */
  public native function setEncode(encode:Boolean):void;

  /**
   * Sets the value of <code>expandData</code>.
   * @param expandData The new value.
   * @see #expandData
   */
  public native function setExpandData(expandData:Boolean):void;

  /**
   * Sets the value of <code>rootProperty</code>.
   * @param rootProperty The new value.
   * @see #rootProperty
   */
  public native function setRootProperty(rootProperty:String):void;
}
}