package ext.data.writer {

[Native("Ext.data.writer.Xml", require)]
/**
 * This class is used to write →<code>ext.data.Model</code> data to the server in an XML format.
 * The →<code>documentRoot</code> property is used to specify the root element in the XML document.
 * The →<code>record</code> option is used to specify the element name for each record that will
 * make up the XML document.
 * @see ext.data.Model
 * @see #documentRoot
 * @see #record
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Xml.html Original Ext JS documentation of 'Ext.data.writer.Xml'
 */
public class XmlWriter extends DataWriter {
  /**
   * @param config @inheritDoc
   */
  public function XmlWriter(config:XmlWriter = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The root to be used if →<code>documentRoot</code> is empty
   * and a root is required to form a valid XML document.
   * @default 'xmlData'
   * @see #documentRoot
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Xml.html#cfg-defaultDocumentRoot Original Ext JS documentation of 'defaultDocumentRoot'
   * @see #getDefaultDocumentRoot()
   * @see #setDefaultDocumentRoot()
   */
  public native function get defaultDocumentRoot():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultDocumentRoot(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the root element of the document. Defaults to
   * <code>'xmlData'</code>. If there is more than 1 record and the root is not specified, the default
   * document root will still be used to ensure a valid XML document is created.
   * <p>If the →<code>record</code> mapping includes a root element name, eg: "SystemInfo&gt;Operation",
   * and the selector includes the root element name, then you must configure this as <code>false</code></p>
   * @default 'xmlData'
   * @see #record
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Xml.html#cfg-documentRoot Original Ext JS documentation of 'documentRoot'
   * @see #getDocumentRoot()
   * @see #setDocumentRoot()
   */
  public native function get documentRoot():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set documentRoot(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A header to use in the XML document (such as setting the encoding
   * or version). Defaults to <code>''</code>.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Xml.html#cfg-header Original Ext JS documentation of 'header'
   * @see #getHeader()
   * @see #setHeader()
   */
  public native function get header():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set header(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the node to use for each record. Defaults to
   * the owning →<code>ext.data.proxy.DataProxy</code>'s <i>Reader</i> (→<code>ext.data.reader.XmlReader</code>)'s
   * →<code>ext.data.reader.XmlReader.record</code> setting, or <code>'record'</code>.
   * @default 'record'
   * @see ext.data.proxy.DataProxy
   * @see ext.data.reader.XmlReader
   * @see ext.data.reader.XmlReader#record
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Xml.html#cfg-record Original Ext JS documentation of 'record'
   * @see #getRecord()
   * @see #setRecord()
   */
  public native function get record():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set record(value:String):void;

  /**
   * Returns the value of <code>defaultDocumentRoot</code>.
   * @see #defaultDocumentRoot
   */
  public native function getDefaultDocumentRoot():String;

  /**
   * Returns the value of <code>documentRoot</code>.
   * @see #documentRoot
   */
  public native function getDocumentRoot():String;

  /**
   * Returns the value of <code>header</code>.
   * @see #header
   */
  public native function getHeader():String;

  /**
   * Returns the value of <code>record</code>.
   * @see #record
   */
  public native function getRecord():String;

  /**
   * Serializes an object to XML.
   * Properties will be serialized as child elements unless their first character is <code>'&#64;'</code>
   * <p>For example:</p>
   * <pre>
   * myWriter.objectToElement('SystemComponent', {
   *     "&#64;SystemNumber": '10118795',
   *     "SystemInfo&gt;SystemName": 'Phase Noise Measurement System',
   *     AssetId: 'DE3208',
   *     AgilentModel: 'E5505A',
   *     SerialNumber: 'US44101357',
   * }, []).join('');
   * </pre>
   * <p>becomes</p>
   * <pre>
   * &lt;SystemComponent SystemNumber="10118795"&gt;
   *   &lt;SystemInfo&gt;
   *       &lt;SystemName&gt;Phase Noise Measurement System&lt;/SystemName&gt;
   *   &lt;/SystemInfo&gt;
   *   &lt;AssetId&gt;DE3208&lt;/AssetId&gt;
   *   &lt;AgilentModel&gt;E5505A&lt;/AgilentModel&gt;
   *   &lt;SerialNumber&gt;US44101357&lt;/SerialNumber&gt;
   * &lt;/SystemComponent&gt;
   * </pre>
   * @param name The element name for the object.
   * @param o The object to serialize.
   * @param output The array into which to serialize the object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.writer.Xml.html#method-objectToElement Original Ext JS documentation of 'objectToElement'
   */
  public native function objectToElement(name:String, o:Object, output:Array = null):void;

  /**
   * Sets the value of <code>defaultDocumentRoot</code>.
   * @param defaultDocumentRoot The new value.
   * @see #defaultDocumentRoot
   */
  public native function setDefaultDocumentRoot(defaultDocumentRoot:String):void;

  /**
   * Sets the value of <code>documentRoot</code>.
   * @param documentRoot The new value.
   * @see #documentRoot
   */
  public native function setDocumentRoot(documentRoot:String):void;

  /**
   * Sets the value of <code>header</code>.
   * @param header The new value.
   * @see #header
   */
  public native function setHeader(header:String):void;

  /**
   * Sets the value of <code>record</code>.
   * @param record The new value.
   * @see #record
   */
  public native function setRecord(record:String):void;
}
}