package ext.dd {
import ext.event.Event;

import js.HTMLElement;

[Native("Ext.dd.DD", require)]
/**
 * A DragDrop implementation where the linked element follows the
 * mouse cursor during a drag.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html Original Ext JS documentation of 'Ext.dd.DD'
 */
public class DD extends DragDrop {
  /**
   * Creates new DD instance.
   * @param id the id of the linked element
   * @param sGroup the group of related DragDrop items
   * @param config an object containing configurable attributes.
   * Valid properties for DD: scroll
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DD(id:String, sGroup:String, config:Object) {
    super(null, null, null);
  }

  /**
   * When set to true, the utility automatically tries to scroll the browser
   * window when a drag and drop element is dragged near the viewport boundary.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#property-scroll Original Ext JS documentation of 'scroll'
   */
  public native function get scroll():Boolean;

  /**
   * @private
   */
  public native function set scroll(value:Boolean):void;

  /**
   * Sets the element to the location of the mousedown or click event,
   * maintaining the cursor location relative to the location on the element
   * that was clicked. Override this if you want to place the element in a
   * location other than where the cursor is.
   * @param el the element to move
   * @param iPageX the X coordinate of the mousedown or drag event
   * @param iPageY the Y coordinate of the mousedown or drag event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-alignElWithMouse Original Ext JS documentation of 'alignElWithMouse'
   */
  public native function alignElWithMouse(el:HTMLElement, iPageX:int, iPageY:int):void;

  /**
   * Sets up config options specific to this class. Overrides
   * Ext.dd.DragDrop, but all versions of this method through the
   * inheritance chain are called
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-applyConfig Original Ext JS documentation of 'applyConfig'
   */
  override public native function applyConfig():void;

  /**
   * Sets the pointer offset to the distance between the linked element's top
   * left corner and the location the element was clicked.
   * @param iPageX the X coordinate of the click
   * @param iPageY the Y coordinate of the click
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-autoOffset Original Ext JS documentation of 'autoOffset'
   */
  public native function autoOffset(iPageX:int, iPageY:int):void;

  /**
   * Event that fires prior to the onDrag event. Overrides
   * Ext.dd.DragDrop.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-b4Drag Original Ext JS documentation of 'b4Drag'
   */
  public native function b4Drag(e:Event):void;

  /**
   * Event that fires prior to the onMouseDown event. Overrides
   * Ext.dd.DragDrop.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-b4MouseDown Original Ext JS documentation of 'b4MouseDown'
   */
  public native function b4MouseDown(e:Event):void;

  /**
   * Saves the most recent position so that we can reset the constraints and
   * tick marks on-demand. We need to know this so that we can calculate the
   * number of pixels the element is offset from its original position.
   * @param iPageX the current x position (this just makes it so we
   * don't have to look it up again)
   * @param iPageY the current y position (this just makes it so we
   * don't have to look it up again)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-cachePosition Original Ext JS documentation of 'cachePosition'
   */
  public native function cachePosition(iPageX:int = 0, iPageY:int = 0):void;

  /**
   * Sets the pointer offset. You can call this directly to force the
   * offset to be in a particular location (e.g., pass in 0,0 to set it
   * to the center of the object)
   * @param iDeltaX the distance from the left
   * @param iDeltaY the distance from the top
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-setDelta Original Ext JS documentation of 'setDelta'
   */
  public native function setDelta(iDeltaX:int, iDeltaY:int):void;

  /**
   * Sets the drag element to the location of the mousedown or click event,
   * maintaining the cursor location relative to the location on the element
   * that was clicked. Override this if you want to place the element in a
   * location other than where the cursor is.
   * @param iPageX the X coordinate of the mousedown or drag event
   * @param iPageY the Y coordinate of the mousedown or drag event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DD.html#method-setDragElPos Original Ext JS documentation of 'setDragElPos'
   */
  public native function setDragElPos(iPageX:int, iPageY:int):void;
}
}