package ext.dd {

[Native("Ext.dd.DDProxy", require)]
/**
 * A DragDrop implementation that inserts an empty, bordered div into
 * the document that follows the cursor during drag operations. At the time of
 * the click, the frame div is resized to the dimensions of the linked html
 * element, and moved to the exact location of the linked element.
 * <p>References to the "frame" element refer to the single proxy element that
 * was created to be dragged in place of all DDProxy elements on the
 * page.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDProxy.html Original Ext JS documentation of 'Ext.dd.DDProxy'
 */
public class DDProxy extends DD {
  /**
   * The default drag frame div id
   * @default "ygddfdiv"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDProxy.html#static-property-dragElId Original Ext JS documentation of 'dragElId'
   */
  public static native function get dragElId():String;

  /**
   * @private
   */
  public static native function set dragElId(value:String):void;

  /**
   * Creates new DDProxy.
   * @param id the id of the linked html element
   * @param sGroup the group of related DragDrop objects
   * @param config an object containing configurable attributes.
   * Valid properties for DDProxy in addition to those in DragDrop:
   * <ul>
   * <li>resizeFrame</li>
   * <li>centerFrame</li>
   * <li>dragElId</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDProxy.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DDProxy(id:String, sGroup:String, config:Object) {
    super(null, null, null);
  }

  /**
   * By default the frame is positioned exactly where the drag element is, so
   * we use the cursor offset provided by Ext.dd.DD. Another option that works only if
   * you do not have constraints on the obj is to have the drag frame centered
   * around the cursor. Set centerFrame to true for this effect.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDProxy.html#property-centerFrame Original Ext JS documentation of 'centerFrame'
   */
  public native function get centerFrame():Boolean;

  /**
   * @private
   */
  public native function set centerFrame(value:Boolean):void;

  /**
   * By default we resize the drag frame to be the same size as the element
   * we want to drag (this is to get the frame effect). We can turn it off
   * if we want a different behavior.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDProxy.html#property-resizeFrame Original Ext JS documentation of 'resizeFrame'
   */
  public native function get resizeFrame():Boolean;

  /**
   * @private
   */
  public native function set resizeFrame(value:Boolean):void;

  /**
   * Creates the proxy element if it does not yet exist
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDProxy.html#method-createFrame Original Ext JS documentation of 'createFrame'
   */
  public native function createFrame():void;

  /**
   * Initialization for the drag frame element. Must be called in the
   * constructor of all subclasses
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDProxy.html#method-initFrame Original Ext JS documentation of 'initFrame'
   */
  public native function initFrame():void;
}
}