package ext.dd {
import ext.event.Event;

import js.HTMLElement;

[Native("Ext.dd.DDTarget", require)]
/**
 * A DragDrop implementation that does not move, but can be a drop
 * target. You would get the same result by simply omitting implementation
 * for the event callbacks, but this way we reduce the processing cost of the
 * event listener and the callbacks.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html Original Ext JS documentation of 'Ext.dd.DDTarget'
 */
public class DDTarget extends DragDrop {
  /**
   * Creates new DDTarget.
   * @param id the id of the element that is a drop target
   * @param sGroup the group of related DragDrop objects
   * @param config an object containing configurable attributes.
   * Valid properties for DDTarget in addition to those in DragDrop: none.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DDTarget(id:String, sGroup:String, config:Object) {
    super(null, null, null);
  }

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param cssClass the class of the elements you wish to ignore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-addInvalidHandleClass Original Ext JS documentation of 'addInvalidHandleClass'
   */
  override public native function addInvalidHandleClass(cssClass:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param id the element id of the element you wish to ignore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-addInvalidHandleId Original Ext JS documentation of 'addInvalidHandleId'
   */
  override public native function addInvalidHandleId(id:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param tagName the type of element to exclude
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-addInvalidHandleType Original Ext JS documentation of 'addInvalidHandleType'
   */
  override public native function addInvalidHandleType(tagName:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-clearConstraints Original Ext JS documentation of 'clearConstraints'
   */
  override public native function clearConstraints():void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-clearTicks Original Ext JS documentation of 'clearTicks'
   */
  override public native function clearTicks():void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mouseup event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-endDrag Original Ext JS documentation of 'endDrag'
   */
  override public native function endDrag(e:Event):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-getDragEl Original Ext JS documentation of 'getDragEl'
   */
  override public native function getDragEl():HTMLElement;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param node the HTMLElement to evaluate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-isValidHandleChild Original Ext JS documentation of 'isValidHandleChild'
   */
  override public native function isValidHandleChild(node:HTMLElement):Boolean;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mousemove event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onDrag Original Ext JS documentation of 'onDrag'
   */
  override public native function onDrag(e:Event):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mouseup event
   * @param id In POINT mode, the element
   * id this was dropped on. In INTERSECT mode, an array of dd items this
   * was dropped on.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onDragDrop Original Ext JS documentation of 'onDragDrop'
   */
  override public native function onDragDrop(e:Event, id:*):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mousemove event
   * @param id In POINT mode, the element
   * id this is hovering over. In INTERSECT mode, an array of one or more
   * dragdrop items being hovered over.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onDragEnter Original Ext JS documentation of 'onDragEnter'
   */
  override public native function onDragEnter(e:Event, id:*):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mousemove event
   * @param id In POINT mode, the element
   * id this was hovering over. In INTERSECT mode, an array of dd items
   * that the mouse is no longer over.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onDragOut Original Ext JS documentation of 'onDragOut'
   */
  override public native function onDragOut(e:Event, id:*):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mousemove event
   * @param id In POINT mode, the element
   * id this is hovering over. In INTERSECT mode, an array of dd items
   * being hovered over.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onDragOver Original Ext JS documentation of 'onDragOver'
   */
  override public native function onDragOver(e:Event, id:*):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mouseup event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onInvalidDrop Original Ext JS documentation of 'onInvalidDrop'
   */
  override public native function onInvalidDrop(e:Event):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mousedown event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onMouseDown Original Ext JS documentation of 'onMouseDown'
   */
  override public native function onMouseDown(e:Event):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param e the mouseup event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-onMouseUp Original Ext JS documentation of 'onMouseUp'
   */
  override public native function onMouseUp(e:Event):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param cssClass the class of the element(s) you wish to
   * re-enable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-removeInvalidHandleClass Original Ext JS documentation of 'removeInvalidHandleClass'
   */
  override public native function removeInvalidHandleClass(cssClass:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param id the id of the element to re-enable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-removeInvalidHandleId Original Ext JS documentation of 'removeInvalidHandleId'
   */
  override public native function removeInvalidHandleId(id:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param tagName the type of element to unexclude
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-removeInvalidHandleType Original Ext JS documentation of 'removeInvalidHandleType'
   */
  override public native function removeInvalidHandleType(tagName:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-resetConstraints Original Ext JS documentation of 'resetConstraints'
   */
  override public native function resetConstraints(maintainOffset:Boolean):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param id the id of the element that will be used to initiate the drag
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-setDragElId Original Ext JS documentation of 'setDragElId'
   */
  override public native function setDragElId(id:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param id the id of the element that will be used to
   * initiate the drag.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-setHandleElId Original Ext JS documentation of 'setHandleElId'
   */
  override public native function setHandleElId(id:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param diffX the X offset, default 0
   * @param diffY the Y offset, default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-setInitPosition Original Ext JS documentation of 'setInitPosition'
   */
  override public native function setInitPosition(diffX:Number, diffY:Number):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param id the id of the element that will be used to initiate the drag
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-setOuterHandleElId Original Ext JS documentation of 'setOuterHandleElId'
   */
  override public native function setOuterHandleElId(id:String):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param iLeft the number of pixels the element can move to the left
   * @param iRight the number of pixels the element can move to the
   * right
   * @param iTickSize parameter for specifying that the
   * element should move iTickSize pixels at a time.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-setXConstraint Original Ext JS documentation of 'setXConstraint'
   */
  override public native function setXConstraint(iLeft:Number, iRight:Number, iTickSize:Number = NaN):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param iUp the number of pixels the element can move up
   * @param iDown the number of pixels the element can move down
   * @param iTickSize parameter for specifying that the
   * element should move iTickSize pixels at a time.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-setYConstraint Original Ext JS documentation of 'setYConstraint'
   */
  override public native function setYConstraint(iUp:Number, iDown:Number, iTickSize:Number = NaN):void;

  /**
   * Overridden and disabled. A DDTarget does not support being dragged.
   * @param x X click location
   * @param y Y click location
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DDTarget.html#method-startDrag Original Ext JS documentation of 'startDrag'
   */
  override public native function startDrag(x:Number, y:Number):void;
}
}