package ext.dd {
import ext.Base;
import ext.event.Event;

import js.HTMLElement;

[Native("Ext.dd.DragDrop", require)]
/**
 * Defines the interface and base operation of items that that can be
 * dragged or can be drop targets. It was designed to be extended, overriding
 * the event handlers for startDrag, onDrag, onDragOver and onDragOut.
 * Up to three html elements can be associated with a DragDrop instance:
 * <ul>
 * <li>
 * <p>linked element: the element that is passed into the constructor.
 * This is the element which defines the boundaries for interaction with
 * other DragDrop objects.</p>
 * </li>
 * <li>
 * <p>handle element(s): The drag operation only occurs if the element that
 * was clicked matches a handle element. By default this is the linked
 * element, but there are times that you will want only a portion of the
 * linked element to initiate the drag operation, and the setHandleElId()
 * method provides a way to define this.</p>
 * </li>
 * <li>
 * <p>drag element: this represents the element that would be moved along
 * with the cursor during a drag operation. By default, this is the linked
 * element itself as in →<code>ext.dd.DD</code>. setDragElId() lets you define
 * a separate element that would be moved, as in →<code>ext.dd.DDProxy</code>.</p>
 * </li>
 * </ul>
 * <p>This class should not be instantiated until the onload event to ensure that
 * the associated elements are available.
 * The following would define a DragDrop obj that would interact with any
 * other DragDrop obj in the "group1" group:</p>
 * <pre>
 * dd = new Ext.dd.DragDrop("div1", "group1");
 * </pre>
 * <p>Since none of the event handlers have been implemented, nothing would
 * actually happen if you were to run the code above. Normally you would
 * override this class or one of the default implementations, but you can
 * also override the methods you want on an instance of the class...</p>
 * <pre>
 * dd.onDragDrop = function(e, id) {
 *     alert("dd was dropped on " + id);
 * }
 * </pre>
 * @see ext.dd.DD
 * @see ext.dd.DDProxy
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html Original Ext JS documentation of 'Ext.dd.DragDrop'
 */
public class DragDrop extends Base {
  /**
   * Creates new DragDrop.
   * @param id of the element that is linked to this instance
   * @param sGroup the group of related DragDrop objects
   * @param config an object containing configurable attributes.
   * Valid properties for DragDrop:
   * <ul>
   * <li>padding</li>
   * <li>isTarget</li>
   * <li>maintainOffset</li>
   * <li>primaryButtonOnly</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DragDrop(id:String, sGroup:String, config:Object) {
    super();
  }

  /**
   * Internal typeof flag.
   */
  public native function get __ygDragDrop():Object;

  /**
   * @private
   */
  public native function set __ygDragDrop(value:Object):void;

  /**
   * Cached reference to the linked element.
   */
  public native function get _domRef():HTMLElement;

  /**
   * @private
   */
  public native function set _domRef(value:HTMLElement):void;

  /**
   * The available property is false until the linked dom element is accessible.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-available Original Ext JS documentation of 'available'
   */
  public native function get available():Boolean;

  /**
   * @private
   */
  public native function set available(value:Boolean):void;

  /**
   * Configuration attributes passed into the constructor
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-config Original Ext JS documentation of 'config'
   */
  public native function get config():Object;

  /**
   * @private
   */
  public native function set config(value:Object):void;

  /**
   * Set to true when horizontal constraints are applied.
   */
  public native function get constrainX():Boolean;

  /**
   * @private
   */
  public native function set constrainX(value:Boolean):void;

  /**
   * Set to true when vertical constraints are applied.
   */
  public native function get constrainY():Boolean;

  /**
   * @private
   */
  public native function set constrainY(value:Boolean):void;

  /**
   * Provides default constraint padding to "constrainTo" elements.
   * @default {
   *     left: 0,
   *     right: 0,
   *     top: 0,
   *     bottom: 0
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-defaultPadding Original Ext JS documentation of 'defaultPadding'
   */
  public native function get defaultPadding():Object;

  /**
   * @private
   */
  public native function set defaultPadding(value:Object):void;

  /**
   * The id of the element that will be dragged. By default this is same as the linked element, but could be changed to another element. Ex: Ext.dd.DDProxy.
   */
  public native function get dragElId():String;

  /**
   * @private
   */
  public native function set dragElId(value:String):void;

  /**
   * The group defines a logical collection of DragDrop objects that are
   * related. Instances only get events when interacting with other
   * DragDrop object in the same group. This lets us define multiple
   * groups using a single DragDrop subclass if we want.
   * <p>An object in the format {'group1':true, 'group2':true}</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-groups Original Ext JS documentation of 'groups'
   */
  public native function get groups():Object;

  /**
   * @private
   */
  public native function set groups(value:Object):void;

  /**
   * The ID of the element that initiates the drag operation. By default this is the linked element, but could be changed to be a child of this element. This lets us do things like only starting the drag when the header element within the linked html element is clicked.
   */
  public native function get handleElId():String;

  /**
   * @private
   */
  public native function set handleElId(value:String):void;

  /**
   * By default, drags can only be initiated if the mousedown occurs in the
   * region the linked element is. This is done in part to work around a
   * bug in some browsers that mis-report the mousedown if the previous
   * mouseup happened outside of the window. This property is set to true
   * if outer handles are defined. Defaults to false.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-hasOuterHandles Original Ext JS documentation of 'hasOuterHandles'
   */
  public native function get hasOuterHandles():Boolean;

  /**
   * @private
   */
  public native function set hasOuterHandles(value:Boolean):void;

  /**
   * The id of the element associated with this object. This is what we
   * refer to as the "linked element" because the size and position of
   * this element is used to determine when the drag and drop objects have
   * interacted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-id Original Ext JS documentation of 'id'
   */
  public native function get id():String;

  /**
   * @private
   */
  public native function set id(value:String):void;

  /**
   * Set to false to enable a DragDrop object to fire drag events while dragging
   * over its own Element. Defaults to true - DragDrop objects do not by default
   * fire drag events to themselves.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-ignoreSelf Original Ext JS documentation of 'ignoreSelf'
   */
  public native function get ignoreSelf():Boolean;

  /**
   * @private
   */
  public native function set ignoreSelf(value:Boolean):void;

  [ArrayElementType("String")]
  /**
   * An Array of CSS class names for elements to be considered in valid as drag handles.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-invalidHandleClasses Original Ext JS documentation of 'invalidHandleClasses'
   */
  public native function get invalidHandleClasses():Array;

  /**
   * @private
   */
  public native function set invalidHandleClasses(value:Array):void;

  /**
   * An object who's property names identify the IDs of elements to be considered invalid
   * as drag handles. A non-null property value identifies the ID as invalid. For example,
   * to prevent dragging from being initiated on element ID "foo", use:
   * <pre>
   * {
   *     foo: true
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-invalidHandleIds Original Ext JS documentation of 'invalidHandleIds'
   */
  public native function get invalidHandleIds():Object;

  /**
   * @private
   */
  public native function set invalidHandleIds(value:Object):void;

  /**
   * An object who's property names identify HTML tags to be considered invalid as drag handles.
   * A non-null property value identifies the tag as invalid. Defaults to the
   * following value which prevents drag operations from being initiated by <code>&lt;a&gt;</code> elements:
   * <pre>
   * {
   *     A: "A"
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-invalidHandleTypes Original Ext JS documentation of 'invalidHandleTypes'
   */
  public native function get invalidHandleTypes():Object;

  /**
   * @private
   */
  public native function set invalidHandleTypes(value:Object):void;

  /**
   * By default, all instances can be a drop target. This can be disabled by
   * setting isTarget to false.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-isTarget Original Ext JS documentation of 'isTarget'
   */
  public native function get isTarget():Boolean;

  /**
   * @private
   */
  public native function set isTarget(value:Boolean):void;

  /**
   * Individual drag/drop instances can be locked. This will prevent onmousedown start drag.
   */
  public native function get locked():Boolean;

  /**
   * @private
   */
  public native function set locked(value:Boolean):void;

  /**
   * Maintain offsets when we resetconstraints. Set to true when you want
   * the position of the element relative to its parent to stay the same
   * when the page changes
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-maintainOffset Original Ext JS documentation of 'maintainOffset'
   */
  public native function get maintainOffset():Boolean;

  /**
   * @private
   */
  public native function set maintainOffset(value:Boolean):void;

  /**
   The right constraint
   * @see http://docs.sencha.com/ext-js/3-4/#!/api/Ext.dd.DragDrop-property-maxX Sencha Docs Ext JS 3.4
   */
  public native function get maxX():int;

  /**
   * @private
   */
  public native function set maxX(value:int):void;

  /**
   * The down constraint.
   */
  public native function get maxY():int;

  /**
   * @private
   */
  public native function set maxY(value:int):void;

  /**
   * The left constraint.
   */
  public native function get minX():int;

  /**
   * @private
   */
  public native function set minX(value:int):void;

  /**
   * The up constraint.
   */
  public native function get minY():int;

  /**
   * @private
   */
  public native function set minY(value:int):void;

  /**
   * When set to true, other DD objects in cooperating DDGroups do not receive
   * notification events when this DD object is dragged over them.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-moveOnly Original Ext JS documentation of 'moveOnly'
   */
  public native function get moveOnly():Boolean;

  /**
   * @private
   */
  public native function set moveOnly(value:Boolean):void;

  [ArrayElementType("Number")]
  /**
   * The padding configured for this drag and drop object for calculating
   * the drop zone intersection with this object.
   * An array containing the 4 padding values: [top, right, bottom, left]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-padding Original Ext JS documentation of 'padding'
   */
  public native function get padding():Array;

  /**
   * @private
   */
  public native function set padding(value:Array):void;

  /**
   * By default the drag and drop instance will only respond to the primary
   * button click (left button for a right-handed mouse). Set to true to
   * allow drag and drop to start with any mouse click that is propogated
   * by the browser
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-primaryButtonOnly Original Ext JS documentation of 'primaryButtonOnly'
   */
  public native function get primaryButtonOnly():Boolean;

  /**
   * @private
   */
  public native function set primaryButtonOnly(value:Boolean):void;

  /**
   * The linked element's absolute X position at the time the drag was started.
   */
  public native function get startPageX():int;

  /**
   * @private
   */
  public native function set startPageX(value:int):void;

  /**
   * The linked element's absolute X position at the time the drag was started.
   */
  public native function get startPageY():int;

  /**
   * @private
   */
  public native function set startPageY(value:int):void;

  [ArrayElementType("Number")]
  /**
   * Array of pixel locations the element will snap to if we specified a
   * horizontal graduation/interval. This array is generated automatically
   * when you define a tick interval.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-xTicks Original Ext JS documentation of 'xTicks'
   */
  public native function get xTicks():Array;

  /**
   * @private
   */
  public native function set xTicks(value:Array):void;

  [ArrayElementType("Number")]
  /**
   * Array of pixel locations the element will snap to if we specified a
   * vertical graduation/interval. This array is generated automatically
   * when you define a tick interval.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#property-yTicks Original Ext JS documentation of 'yTicks'
   */
  public native function get yTicks():Array;

  /**
   * @private
   */
  public native function set yTicks(value:Array):void;

  /**
   * Lets you specify a css class of elements that will not initiate a drag
   * @param cssClass the class of the elements you wish to ignore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-addInvalidHandleClass Original Ext JS documentation of 'addInvalidHandleClass'
   */
  public native function addInvalidHandleClass(cssClass:String):void;

  /**
   * Lets you to specify an element id for a child of a drag handle
   * that should not initiate a drag
   * @param id the element id of the element you wish to ignore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-addInvalidHandleId Original Ext JS documentation of 'addInvalidHandleId'
   */
  public native function addInvalidHandleId(id:String):void;

  /**
   * Allows you to specify a tag name that should not start a drag operation
   * when clicked. This is designed to facilitate embedding links within a
   * drag handle that do something other than start the drag.
   * @param tagName the type of element to exclude
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-addInvalidHandleType Original Ext JS documentation of 'addInvalidHandleType'
   */
  public native function addInvalidHandleType(tagName:String):void;

  /**
   * Adds this instance to a group of related drag/drop objects. All
   * instances belong to at least one group, and can belong to as many
   * groups as needed.
   * @param sGroup the name of the group
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-addToGroup Original Ext JS documentation of 'addToGroup'
   */
  public native function addToGroup(sGroup:String):void;

  /**
   * Applies the configuration parameters that were passed into the constructor.
   * This is supposed to happen at each level through the inheritance chain. So
   * a DDProxy implentation will execute apply config on DDProxy, DD, and
   * DragDrop in order to get all of the parameters that are available in
   * each object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-applyConfig Original Ext JS documentation of 'applyConfig'
   */
  public native function applyConfig():void;

  /**
   * Clears any constraints applied to this instance. Also clears ticks
   * since they can't exist independent of a constraint at this time.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-clearConstraints Original Ext JS documentation of 'clearConstraints'
   */
  public native function clearConstraints():void;

  /**
   * Clears any tick interval defined for this instance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-clearTicks Original Ext JS documentation of 'clearTicks'
   */
  public native function clearTicks():void;

  /**
   * Initializes the drag drop object's constraints to restrict movement to a certain element.
   * <p>Usage:</p>
   * <pre>
   * var dd = new Ext.dd.DDProxy("dragDiv1", "proxytest",
   *                { dragElId: "existingProxyDiv" });
   * dd.startDrag = function(){
   *     this.constrainTo("parent-id");
   * };
   * </pre>
   * <p>Or you can initalize it using the →<code>ext.dom.Element</code> object:</p>
   * <pre>
   * Ext.get("dragDiv1").initDDProxy("proxytest", {dragElId: "existingProxyDiv"}, {
   *     startDrag : function(){
   *         this.constrainTo("parent-id");
   *     }
   * });
   * </pre>
   * @param constrainTo The element or element ID
   * to constrain to.
   * @param pad Pad provides a way to specify "padding"
   * of the constraints, and can be either a number for symmetrical padding (4 would be equal to
   * <code>{ left: 4, right: 4, top: 4, bottom: 4 }</code>) or an object containing the sides to pad.
   * For example: <code>{ right: 10, bottom: 10 }</code>
   * @param inContent Constrain the draggable in the content box
   * of the element (inside padding and borders)
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-constrainTo Original Ext JS documentation of 'constrainTo'
   */
  public native function constrainTo(constrainTo:*, pad:* = null, inContent:Boolean = false):void;

  /**
   * Called when we are done dragging the object
   * @param e the mouseup event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-endDrag Original Ext JS documentation of 'endDrag'
   */
  public native function endDrag(e:Event):void;

  /**
   * Returns a reference to the actual element to drag. By default this is
   * the same as the html element, but it can be assigned to another
   * element. An example of this can be found in Ext.dd.DDProxy
   * @return the html element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-getDragEl Original Ext JS documentation of 'getDragEl'
   */
  public native function getDragEl():HTMLElement;

  /**
   * Returns a reference to the linked element
   * @return the html element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-getEl Original Ext JS documentation of 'getEl'
   */
  public native function getEl():HTMLElement;

  /**
   * Sets up the DragDrop object. Must be called in the constructor of any
   * Ext.dd.DragDrop subclass
   * @param id the id of the linked element
   * @param sGroup the group of related items
   * @param config configuration attributes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-init Original Ext JS documentation of 'init'
   */
  public native function init(id:String, sGroup:String, config:Object):void;

  /**
   * Initializes Targeting functionality only... the object does not
   * get a mousedown handler.
   * @param id the id of the linked element
   * @param sGroup the group of related items
   * @param config configuration attributes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-initTarget Original Ext JS documentation of 'initTarget'
   */
  public native function initTarget(id:String, sGroup:String, config:Object):void;

  /**
   * Returns true if this instance is locked, or the drag drop mgr is locked
   * (meaning that all drag/drop is disabled on the page.)
   * @return true if this obj or all drag/drop is locked, else
   * false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-isLocked Original Ext JS documentation of 'isLocked'
   */
  public native function isLocked():Boolean;

  /**
   * Checks the tag exclusion list to see if this click should be ignored
   * @param node the HTMLElement to evaluate
   * @return true if this is a valid tag type, false if not
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-isValidHandleChild Original Ext JS documentation of 'isValidHandleChild'
   */
  public native function isValidHandleChild(node:HTMLElement):Boolean;

  /**
   * Locks this instance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-lock Original Ext JS documentation of 'lock'
   */
  public native function lock():void;

  /**
   * Override the onAvailable method to do what is needed after the initial
   * position was determined.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onAvailable Original Ext JS documentation of 'onAvailable'
   */
  public native function onAvailable():void;

  /**
   * Abstract method called during the onMouseMove event while dragging an
   * object.
   * @param e the mousemove event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onDrag Original Ext JS documentation of 'onDrag'
   */
  public native function onDrag(e:Event):void;

  /**
   * Abstract method called when this item is dropped on another DragDrop
   * obj
   * @param e the mouseup event
   * @param id In POINT mode, the element
   * id this was dropped on. In INTERSECT mode, an array of dd items this
   * was dropped on.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onDragDrop Original Ext JS documentation of 'onDragDrop'
   */
  public native function onDragDrop(e:Event, id:*):void;

  /**
   * Abstract method called when this element fist begins hovering over
   * another DragDrop obj
   * @param e the mousemove event
   * @param id In POINT mode, the element
   * id this is hovering over. In INTERSECT mode, an array of one or more
   * dragdrop items being hovered over.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onDragEnter Original Ext JS documentation of 'onDragEnter'
   */
  public native function onDragEnter(e:Event, id:*):void;

  /**
   * Abstract method called when we are no longer hovering over an element
   * @param e the mousemove event
   * @param id In POINT mode, the element
   * id this was hovering over. In INTERSECT mode, an array of dd items
   * that the mouse is no longer over.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onDragOut Original Ext JS documentation of 'onDragOut'
   */
  public native function onDragOut(e:Event, id:*):void;

  /**
   * Abstract method called when this element is hovering over another
   * DragDrop obj
   * @param e the mousemove event
   * @param id In POINT mode, the element
   * id this is hovering over. In INTERSECT mode, an array of dd items
   * being hovered over.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onDragOver Original Ext JS documentation of 'onDragOver'
   */
  public native function onDragOver(e:Event, id:*):void;

  /**
   * Abstract method called when this item is dropped on an area with no
   * drop target
   * @param e the mouseup event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onInvalidDrop Original Ext JS documentation of 'onInvalidDrop'
   */
  public native function onInvalidDrop(e:Event):void;

  /**
   * Called when a drag/drop obj gets a mousedown
   * @param e the mousedown event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onMouseDown Original Ext JS documentation of 'onMouseDown'
   */
  public native function onMouseDown(e:Event):void;

  /**
   * Called when a drag/drop obj gets a mouseup
   * @param e the mouseup event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-onMouseUp Original Ext JS documentation of 'onMouseUp'
   */
  public native function onMouseUp(e:Event):void;

  /**
   * Removes this instance from the supplied interaction group
   * @param sGroup The group to drop
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-removeFromGroup Original Ext JS documentation of 'removeFromGroup'
   */
  public native function removeFromGroup(sGroup:String):void;

  /**
   * Unsets an invalid css class
   * @param cssClass the class of the element(s) you wish to
   * re-enable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-removeInvalidHandleClass Original Ext JS documentation of 'removeInvalidHandleClass'
   */
  public native function removeInvalidHandleClass(cssClass:String):void;

  /**
   * Unsets an invalid handle id
   * @param id the id of the element to re-enable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-removeInvalidHandleId Original Ext JS documentation of 'removeInvalidHandleId'
   */
  public native function removeInvalidHandleId(id:String):void;

  /**
   * Unsets an excluded tag name set by addInvalidHandleType
   * @param tagName the type of element to unexclude
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-removeInvalidHandleType Original Ext JS documentation of 'removeInvalidHandleType'
   */
  public native function removeInvalidHandleType(tagName:String):void;

  /**
   * Must be called if you manually reposition a dd element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-resetConstraints Original Ext JS documentation of 'resetConstraints'
   */
  public native function resetConstraints(maintainOffset:Boolean):void;

  /**
   * Allows you to specify that an element other than the linked element
   * will be moved with the cursor during a drag
   * @param id the id of the element that will be used to initiate the drag
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-setDragElId Original Ext JS documentation of 'setDragElId'
   */
  public native function setDragElId(id:String):void;

  /**
   * Allows you to specify a child of the linked element that should be
   * used to initiate the drag operation. An example of this would be if
   * you have a content div with text and links. Clicking anywhere in the
   * content area would normally start the drag operation. Use this method
   * to specify that an element inside of the content div is the element
   * that starts the drag operation.
   * @param id the id of the element that will be used to
   * initiate the drag.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-setHandleElId Original Ext JS documentation of 'setHandleElId'
   */
  public native function setHandleElId(id:String):void;

  /**
   * Stores the initial placement of the linked element.
   * @param diffX the X offset, default 0
   * @param diffY the Y offset, default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-setInitPosition Original Ext JS documentation of 'setInitPosition'
   */
  public native function setInitPosition(diffX:Number, diffY:Number):void;

  /**
   * Allows you to set an element outside of the linked element as a drag
   * handle
   * @param id the id of the element that will be used to initiate the drag
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-setOuterHandleElId Original Ext JS documentation of 'setOuterHandleElId'
   */
  public native function setOuterHandleElId(id:String):void;

  /**
   * Configures the padding for the target zone in px. Effectively expands
   * (or reduces) the virtual object size for targeting calculations.
   * Supports css-style shorthand; if only one parameter is passed, all sides
   * will have that padding, and if only two are passed, the top and bottom
   * will have the first param, the left and right the second.
   * @param iTop Top pad
   * @param iRight Right pad
   * @param iBot Bot pad
   * @param iLeft Left pad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-setPadding Original Ext JS documentation of 'setPadding'
   */
  public native function setPadding(iTop:Number, iRight:Number, iBot:Number, iLeft:Number):void;

  /**
   * By default, the element can be dragged any place on the screen. Use
   * this method to limit the horizontal travel of the element. Pass in
   * 0,0 for the parameters if you want to lock the drag to the y axis.
   * @param iLeft the number of pixels the element can move to the left
   * @param iRight the number of pixels the element can move to the
   * right
   * @param iTickSize parameter for specifying that the
   * element should move iTickSize pixels at a time.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-setXConstraint Original Ext JS documentation of 'setXConstraint'
   */
  public native function setXConstraint(iLeft:Number, iRight:Number, iTickSize:Number = NaN):void;

  /**
   * By default, the element can be dragged any place on the screen. Set
   * this to limit the vertical travel of the element. Pass in 0,0 for the
   * parameters if you want to lock the drag to the x axis.
   * @param iUp the number of pixels the element can move up
   * @param iDown the number of pixels the element can move down
   * @param iTickSize parameter for specifying that the
   * element should move iTickSize pixels at a time.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-setYConstraint Original Ext JS documentation of 'setYConstraint'
   */
  public native function setYConstraint(iUp:Number, iDown:Number, iTickSize:Number = NaN):void;

  /**
   * Abstract method called after a drag/drop object is clicked
   * and the drag or mousedown time thresholds have beeen met.
   * @param x X click location
   * @param y Y click location
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-startDrag Original Ext JS documentation of 'startDrag'
   */
  public native function startDrag(x:Number, y:Number):void;

  /**
   * toString method
   * @return string representation of the dd obj
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-toString Original Ext JS documentation of 'toString'
   */
  public native function toString():String;

  /**
   * Unlocks this instace
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-unlock Original Ext JS documentation of 'unlock'
   */
  public native function unlock():void;

  /**
   * Removes all drag and drop hooks for this element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDrop.html#method-unreg Original Ext JS documentation of 'unreg'
   */
  public native function unreg():void;
}
}