package ext.dd {
import js.HTMLElement;

[Native("Ext.dd.DragDropElement", require)]
/**
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html Original Ext JS documentation of 'Ext.dd.DragDropElement'
 */
public class DragDropElement extends Object {
  /**
   * Returns the X position of an html element
   * @param el the element for which to get the position
   * @return the X coordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-getPosX Original Ext JS documentation of 'getPosX'
   */
  public native function getPosX(el:HTMLElement):Number;

  /**
   * Returns the Y position of an html element
   * @param el the element for which to get the position
   * @return the Y coordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-getPosY Original Ext JS documentation of 'getPosY'
   */
  public native function getPosY(el:HTMLElement):Number;

  /**
   * Gets the scrollLeft
   * @return the document's scrollTop
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-getScrollLeft Original Ext JS documentation of 'getScrollLeft'
   */
  public native function getScrollLeft():Number;

  /**
   * Gets the scrollTop
   * @return the document's scrollTop
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-getScrollTop Original Ext JS documentation of 'getScrollTop'
   */
  public native function getScrollTop():Number;

  /**
   * Returns the specified element style property
   * @param el the element
   * @param styleProp the style property
   * @return The value of the style property
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-getStyle Original Ext JS documentation of 'getStyle'
   */
  public native function getStyle(el:HTMLElement, styleProp:String):String;

  /**
   * Recursively searches the immediate parent and all child nodes for
   * the handle element in order to determine whether or not it was
   * clicked.
   * @param node the html element to inspect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-handleWasClicked Original Ext JS documentation of 'handleWasClicked'
   */
  public native function handleWasClicked(node:HTMLElement, id:String):Boolean;

  /**
   * Sets the x/y position of an element to the location of the
   * target element.
   * @param moveEl The element to move
   * @param targetEl The position reference element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-moveToEl Original Ext JS documentation of 'moveToEl'
   */
  public native function moveToEl(moveEl:HTMLElement, targetEl:HTMLElement):void;

  /**
   * Numeric array sort function
   * @return positive, negative or 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-numericSort Original Ext JS documentation of 'numericSort'
   */
  public native function numericSort(a:Number, b:Number):Number;

  /**
   * Swap two nodes. In IE, we use the native method, for others we
   * emulate the IE behavior
   * @param n1 the first node to swap
   * @param n2 the other node to swap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropElement.html#method-swapNode Original Ext JS documentation of 'swapNode'
   */
  public native function swapNode(n1:HTMLElement, n2:HTMLElement):void;
}
}