package ext.dd {
import ext.event.Event;

[Native("Ext.dd.DragSource", require)]
/**
 * A simple class that provides the basic implementation needed to make any element draggable.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html Original Ext JS documentation of 'Ext.dd.DragSource'
 */
public class DragSource extends DDProxy {
  /**
   * Creates new drag-source.
   * @param el The container element or ID of it.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DragSource(el:*, config:DragSource = null) {
    super(null, null, null);
  }

  [ExtConfig]
  /**
   * If true, animates the proxy element back to the position of the handle element used to
   * trigger the drag.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#cfg-animRepair Original Ext JS documentation of 'animRepair'
   */
  public native function get animRepair():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animRepair(value:Boolean):void;

  [ExtConfig]
  /**
   * A named drag drop group to which this object belongs. If a group is specified, then this
   * object will only interact with other drag drop objects in the same group.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#cfg-ddGroup Original Ext JS documentation of 'ddGroup'
   */
  public native function get ddGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ddGroup(value:String):void;

  /**
   * This property contains the data representing the dragged object. This data is set up
   * by the implementation of the →<code>getDragData()</code> method. It must contain a ddel property,
   * but can contain any other data according to the application's needs.
   * @see #getDragData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#property-dragData Original Ext JS documentation of 'dragData'
   */
  public native function get dragData():Object;

  /**
   * @private
   */
  public native function set dragData(value:Object):void;

  [ExtConfig]
  /**
   * The CSS class returned to the drag source when drop is allowed.
   * @default Ext.baseCSSPrefix + 'dd-drop-ok'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#cfg-dropAllowed Original Ext JS documentation of 'dropAllowed'
   */
  public native function get dropAllowed():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropAllowed(value:String):void;

  [ExtConfig]
  /**
   * The CSS class returned to the drag source when drop is not allowed.
   * @default Ext.baseCSSPrefix + 'dd-drop-nodrop'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#cfg-dropNotAllowed Original Ext JS documentation of 'dropNotAllowed'
   */
  public native function get dropNotAllowed():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropNotAllowed(value:String):void;

  [ExtConfig]
  /**
   * The color to use when visually highlighting the drag source in the afterRepair
   * method after a failed drop (defaults to light blue). The color must be a 6 digit hex value,
   * without a preceding '#'.
   * @default 'c3daf9'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#cfg-repairHighlightColor Original Ext JS documentation of 'repairHighlightColor'
   */
  public native function get repairHighlightColor():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set repairHighlightColor(value:String):void;

  /**
   * An empty function by default, but provided so that you can perform a custom
   * action after a valid drag drop has occurred by providing an implementation.
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dropped element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-afterDragDrop Original Ext JS documentation of 'afterDragDrop'
   */
  public native function afterDragDrop(target:DragDrop, e:Event, id:String):void;

  /**
   * An empty function by default, but provided so that you can perform a custom
   * action when the dragged item enters the drop target by providing
   * an implementation.
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-afterDragEnter Original Ext JS documentation of 'afterDragEnter'
   */
  public native function afterDragEnter(target:DragDrop, e:Event, id:String):void;

  /**
   * An empty function by default, but provided so that you can perform a custom
   * action after the dragged item is dragged out of the target without dropping.
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-afterDragOut Original Ext JS documentation of 'afterDragOut'
   */
  public native function afterDragOut(target:DragDrop, e:Event, id:String):void;

  /**
   * An empty function by default, but provided so that you can perform a custom
   * action while the dragged item is over the drop target by providing
   * an implementation.
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-afterDragOver Original Ext JS documentation of 'afterDragOver'
   */
  public native function afterDragOver(target:DragDrop, e:Event, id:String):void;

  /**
   * An empty function by default, but provided so that you can perform a custom action
   * after an invalid drop has occurred by providing an implementation.
   * @param e The event object
   * @param id The id of the dropped element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-afterInvalidDrop Original Ext JS documentation of 'afterInvalidDrop'
   */
  public native function afterInvalidDrop(e:Event, id:String):void;

  /**
   * An empty function by default, but provided so that you can perform a custom action
   * after a valid drop has occurred by providing an implementation.
   * @param target The target DD
   * @param e The event object
   * @param id The id of the dropped element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-afterValidDrop Original Ext JS documentation of 'afterValidDrop'
   */
  public native function afterValidDrop(target:Object, e:Event, id:String):void;

  /**
   * An empty function by default, but provided so that you can perform a custom action before
   * the dragged item is dropped onto the target and optionally cancel the onDragDrop.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @return isValid True if the drag drop event is valid, else false to cancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-beforeDragDrop Original Ext JS documentation of 'beforeDragDrop'
   */
  public native function beforeDragDrop(target:DragDrop, e:Event, id:String):Boolean;

  /**
   * An empty function by default, but provided so that you can perform a custom action
   * before the dragged item enters the drop target and optionally cancel the onDragEnter.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @return isValid True if the drag event is valid, else false to cancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-beforeDragEnter Original Ext JS documentation of 'beforeDragEnter'
   */
  public native function beforeDragEnter(target:DragDrop, e:Event, id:String):Boolean;

  /**
   * An empty function by default, but provided so that you can perform a custom action before
   * the dragged item is dragged out of the target without dropping, and optionally cancel
   * the onDragOut.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @return isValid True if the drag event is valid, else false to cancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-beforeDragOut Original Ext JS documentation of 'beforeDragOut'
   */
  public native function beforeDragOut(target:DragDrop, e:Event, id:String):Boolean;

  /**
   * An empty function by default, but provided so that you can perform a custom action
   * while the dragged item is over the drop target and optionally cancel the onDragOver.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @return isValid True if the drag event is valid, else false to cancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-beforeDragOver Original Ext JS documentation of 'beforeDragOver'
   */
  public native function beforeDragOver(target:DragDrop, e:Event, id:String):Boolean;

  /**
   * An empty function by default, but provided so that you can perform a custom action after
   * an invalid drop has occurred.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param target The drop target
   * @param e The event object
   * @param id The id of the dragged element
   * @return isValid True if the invalid drop should proceed, else false to cancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-beforeInvalidDrop Original Ext JS documentation of 'beforeInvalidDrop'
   */
  public native function beforeInvalidDrop(target:DragDrop, e:Event, id:String):Boolean;

  /**
   * Returns the data object associated with this drag source
   * @return data An object containing arbitrary data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-getDragData Original Ext JS documentation of 'getDragData'
   */
  public native function getDragData(e:Event):Object;

  /**
   * Returns the drag source's underlying →<code>ext.dd.StatusProxy</code>
   * @return proxy The StatusProxy
   * @see ext.dd.StatusProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-getProxy Original Ext JS documentation of 'getProxy'
   */
  public native function getProxy():StatusProxy;

  /**
   * Hides the drag source's →<code>ext.dd.StatusProxy</code>
   * @see ext.dd.StatusProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-hideProxy Original Ext JS documentation of 'hideProxy'
   */
  public native function hideProxy():void;

  /**
   * An empty function by default, but provided so that you can perform a custom action before
   * the initial drag event begins and optionally cancel it.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param data An object containing arbitrary data to be shared with drop targets
   * @param e The event object
   * @return isValid True if the drag event is valid, else false to cancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-onBeforeDrag Original Ext JS documentation of 'onBeforeDrag'
   */
  public native function onBeforeDrag(data:Object, e:Event):Boolean;

  /**
   * An empty function by default, but provided so that you can perform a custom action once
   * the initial drag event has begun. The drag cannot be canceled from this function.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param x The x position of the click on the dragged object
   * @param y The y position of the click on the dragged object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragSource.html#method-onStartDrag Original Ext JS documentation of 'onStartDrag'
   */
  public native function onStartDrag(x:Number, y:Number):void;

  [ExtConfig]
  /**
   * Whether HTML5 drag and drop shall be enabled on this drag target.
   *
   * Defaults to false.
   */
  public native function get enableHtml5DD():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableHtml5DD(value:Boolean):void;
}
}