package ext.dd {
import ext.dom.Element;
import ext.event.Event;
import ext.mixin.Observable;

import js.HTMLElement;

[Native("Ext.dd.DragTracker", require)]
/**
 * @see ext.dd.events.DragTracker_eEvent.BEFORE_DRAG_START
 * @eventType ext.dd.events.DragTracker_eEvent.BEFORE_DRAG_START
 */
[Event(name='onBeforeDragStart', type='ext.dd.events.DragTracker_eEvent')]
/**
 * @see ext.dd.events.DragTracker_eEvent.DRAG
 * @eventType ext.dd.events.DragTracker_eEvent.DRAG
 */
[Event(name='onDrag', type='ext.dd.events.DragTracker_eEvent')]
/**
 * @see ext.dd.events.DragTracker_eEvent.DRAG_END
 * @eventType ext.dd.events.DragTracker_eEvent.DRAG_END
 */
[Event(name='onDragEnd', type='ext.dd.events.DragTracker_eEvent')]
/**
 * @see ext.dd.events.DragTracker_eEvent.DRAG_START
 * @eventType ext.dd.events.DragTracker_eEvent.DRAG_START
 */
[Event(name='onDragStart', type='ext.dd.events.DragTracker_eEvent')]
/**
 * @see ext.dd.events.DragTracker_eEvent.MOUSE_DOWN
 * @eventType ext.dd.events.DragTracker_eEvent.MOUSE_DOWN
 */
[Event(name='onMouseDown', type='ext.dd.events.DragTracker_eEvent')]
/**
 * @see ext.dd.events.DragTracker_eEvent.MOUSE_MOVE
 * @eventType ext.dd.events.DragTracker_eEvent.MOUSE_MOVE
 */
[Event(name='onMouseMove', type='ext.dd.events.DragTracker_eEvent')]
/**
 * @see ext.dd.events.DragTracker_eEvent.MOUSE_OUT
 * @eventType ext.dd.events.DragTracker_eEvent.MOUSE_OUT
 */
[Event(name='onMouseOut', type='ext.dd.events.DragTracker_eEvent')]
/**
 * @see ext.dd.events.DragTracker_e_targetEvent.MOUSE_OVER
 * @eventType ext.dd.events.DragTracker_e_targetEvent.MOUSE_OVER
 */
[Event(name='onMouseOver', type='ext.dd.events.DragTracker_e_targetEvent')]
/**
 * @see ext.dd.events.DragTracker_eEvent.MOUSE_UP
 * @eventType ext.dd.events.DragTracker_eEvent.MOUSE_UP
 */
[Event(name='onMouseUp', type='ext.dd.events.DragTracker_eEvent')]
/**
 * A DragTracker listens for drag events on an Element and fires events at the start and end of the
 * drag, as well as during the drag. This is useful for components such as →<code>ext.slider.MultiSlider</code>,
 * where there is an element that can be dragged around to change the Slider's value.
 * <p>DragTracker provides a series of template methods that should be overridden to provide
 * functionality in response to detected drag operations. These are onBeforeStart, onStart, onDrag,
 * onCancel and onEnd.
 * See →<code>ext.slider.MultiSlider</code>'s initEvents function for an example implementation.</p>
 * @see ext.slider.MultiSlider
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html Original Ext JS documentation of 'Ext.dd.DragTracker'
 */
public class DragTracker extends Observable {
  /**
   * @param config @inheritDoc
   */
  public function DragTracker(config:DragTracker = null) {
    super();
  }

  /**
   * Indicates whether the user is currently dragging this tracker.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#property-active Original Ext JS documentation of 'active'
   */
  public native function get active():Boolean;

  [ExtConfig]
  /**
   * Specify <code>true</code> to defer trigger start by 1000 ms.
   * Specify a Number for the number of milliseconds to defer trigger start.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-autoStart Original Ext JS documentation of 'autoStart'
   */
  public native function get autoStart():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoStart(value:*):void;

  [ExtConfig]
  /**
   * A →<code>ext.util.Region</code> (Or an element from which a Region measurement will be read)
   * which is used to constrain the result of the →<code>getOffset()</code> call.
   * <p>This may be set any time during the DragTracker's lifecycle to set a dynamic constraining
   * region.</p>
   * @see ext.util.Region
   * @see #getOffset()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-constrainTo Original Ext JS documentation of 'constrainTo'
   */
  public native function get constrainTo():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrainTo(value:*):void;

  [ExtConfig]
  /**
   * A CSS selector which identifies child elements within the DragTracker's encapsulating
   * Element which are the tracked elements. This limits tracking to only begin when the matching
   * elements are mousedowned.
   * <p>This may also be a specific child element within the DragTracker's encapsulating element
   * to use as the tracked element.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-delegate Original Ext JS documentation of 'delegate'
   */
  public native function get delegate():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set delegate(value:String):void;

  /**
   * The element being dragged.
   * <p>Only valid during drag operations.</p>
   * <p>If the →<code>delegate</code> option is used, this will be the delegate element which was
   * mousedowned.</p>
   * @see #delegate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#property-dragTarget Original Ext JS documentation of 'dragTarget'
   */
  public native function get dragTarget():HTMLElement;

  [ExtConfig]
  /**
   * The target element or ID of the element on which the DragTracker will be initialized.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-el Original Ext JS documentation of 'el'
   */
  public native function get el():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set el(value:*):void;

  [ExtConfig]
  /**
   * A CSS class to add to the DragTracker's target element when the element (or, if the
   * →<code>delegate</code> option is used, when a delegate element) is mouseovered.
   * <p>If the →<code>delegate</code> option is used, these events fire only when a delegate element
   * is entered of left.</p>
   * @see #delegate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-overCls Original Ext JS documentation of 'overCls'
   */
  public native function get overCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overCls(value:String):void;

  [ExtConfig]
  /**
   * Specify <code>false</code> to enable default actions on onMouseDown events.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-preventDefault Original Ext JS documentation of 'preventDefault'
   */
  public native function get preventDefault():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventDefault(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify <code>true</code> to stop the <code>→event:onMouseDown</code> event from bubbling to outer listeners from the target
   * element (or its delegates).
   * @default false
   * @see #event:onMouseDown
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-stopEvent Original Ext JS documentation of 'stopEvent'
   */
  public native function get stopEvent():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stopEvent(value:Boolean):void;

  [ExtConfig]
  /**
   * Number of pixels the drag target must be moved before dragging is
   * considered to have started.
   * @default 5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-tolerance Original Ext JS documentation of 'tolerance'
   */
  public native function get tolerance():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tolerance(value:Number):void;

  [ExtConfig]
  /**
   * Set to true to fire mouseover and mouseout events when the mouse enters or leaves the target
   * element.
   * <p>This is implicitly set when an →<code>overCls</code> is specified.</p>
   * <p>If the →<code>delegate</code> option is used, these events fire only when a delegate element
   * is entered of left.</p>
   * @default false
   * @see #overCls
   * @see #delegate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#cfg-trackOver Original Ext JS documentation of 'trackOver'
   */
  public native function get trackOver():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trackOver(value:Boolean):void;

  /**
   * Returns the drag target. This is usually the DragTracker's encapsulating element.
   * <p>If the →<code>delegate</code> option is being used, this may be a child element which matches the
   * →<code>delegate</code> selector.</p>
   * @return The element currently being tracked.
   * @see #delegate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-getDragTarget Original Ext JS documentation of 'getDragTarget'
   */
  public native function getDragTarget():Element;

  [ArrayElementType("Number")]
  /**
   * Returns the X, Y offset of the current mouse position from the mousedown point.
   * <p>This method may optionally constrain the real offset values, and returns a point coerced
   * in one of two modes:</p>
   * <ul>
   * <li><code>point</code> The current mouse position is coerced into the constrainRegion and the resulting
   * position is returned.</li>
   * <li><code>→dragTarget</code> The new →<code>ext.util.Region</code> of the
   * <i>dragTarget</i> (→<code>getDragTarget()</code>) is calculated based upon the current mouse position,
   * and then coerced into the constrainRegion. The returned mouse position is then adjusted
   * by the same delta as was used to coerce the region.</li>
   * </ul>
   * @param constrain If omitted the true mouse position is returned.
   * May be passed as <code>point</code> or <code>→dragTarget</code>. See above.
   * @return The <code>X, Y</code> offset from the mousedown point, optionally constrained.
   * @see #dragTarget
   * @see ext.util.Region
   * @see #getDragTarget()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-getOffset Original Ext JS documentation of 'getOffset'
   */
  public native function getOffset(constrain:String = null):Array;

  /**
   * Initializes the DragTracker on a given element.
   * @param el The element or element ID
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-initEl Original Ext JS documentation of 'initEl'
   */
  public native function initEl(el:*):void;

  /**
   * Template method which should be overridden by each DragTracker instance. Called when the user
   * first clicks and holds the mouse button down. Return false to disallow the drag
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-onBeforeStart Original Ext JS documentation of 'onBeforeStart'
   */
  public native function onBeforeStart(e:Event):void;

  /**
   * Template method which mey be overridden by each DragTracker instance. Called when a mouseup
   * gesture is detected but the onStart has not yet been reached. To clear things up
   * that may have been set up on →<code>onBeforeStart()</code>.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The event object
   * @see #onBeforeStart()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-onCancel Original Ext JS documentation of 'onCancel'
   */
  public native function onCancel(e:Event):void;

  /**
   * Template method which should be overridden by each DragTracker instance. Called whenever
   * a drag has been detected.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-onDrag Original Ext JS documentation of 'onDrag'
   */
  public native function onDrag(e:Event):void;

  /**
   * Template method which should be overridden by each DragTracker instance. Called when a drag
   * operation has been completed (e.g. the user clicked and held the mouse down, dragged
   * the element and then released the mouse button)
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-onEnd Original Ext JS documentation of 'onEnd'
   */
  public native function onEnd(e:Event):void;

  /**
   * Template method which should be overridden by each DragTracker instance. Called when a drag
   * operation starts (e.g. the user has moved the tracked element beyond the specified tolerance)
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragTracker.html#method-onStart Original Ext JS documentation of 'onStart'
   */
  public native function onStart(e:Event):void;
}
}