package ext.dd {
import ext.event.Event;

[Native("Ext.dd.DragZone", require)]
/**
 * This class provides a container DD instance that allows dragging of multiple child source nodes.
 * <p>This class does not move the drag target nodes, but a proxy element which may contain any DOM
 * structure you wish. The DOM element to show in the proxy is provided by either a provided
 * implementation of →<code>getDragData()</code>, or by registered draggables registered with
 * →<code>ext.dd.Registry</code></p>
 * <p>If you wish to provide draggability for an arbitrary number of DOM nodes, each of which represent
 * some application object (For example nodes in a →<code>ext.view.DataView</code>) then use of this
 * class is the most efficient way to "activate" those nodes.</p>
 * <p>By default, this class requires that draggable child nodes are registered with
 * →<code>ext.dd.Registry</code>. However a simpler way to allow a DragZone to manage any number
 * of draggable elements is to configure the DragZone with an implementation of the
 * →<code>getDragData()</code> method which interrogates the passed mouse event to see if it has taken
 * place within an element, or class of elements. This is easily done by using the event's →<code>ext.event.Event.getTarget()</code> method to identify a node based on a CSS selector.
 * For example, to make the nodes of a DataView draggable, use the following technique.
 * Knowledge of the use of the DataView is required:</p>
 * <pre>
 * myDataView.on('render', function(v) {
 *     myDataView.dragZone = new Ext.dd.DragZone(v.getEl(), {
 *
 * //      On receipt of a mousedown event, see if it is within a DataView node.
 * //      Return a drag data object if so.
 *         getDragData: function(e) {
 *
 * //          Use the DataView's own itemSelector (a mandatory property) to
 * //          test if the mousedown is within one of the DataView's nodes.
 *             var sourceEl = e.getTarget(v.itemSelector, 10);
 *
 * //          If the mousedown is within a DataView node, clone the node to produce
 * //          a ddel element for use by the drag proxy. Also add application data
 * //          to the returned data object.
 *             if (sourceEl) {
 *                 d = sourceEl.cloneNode(true);
 *                 d.id = Ext.id();
 *                 return {
 *                     ddel: d,
 *                     sourceEl: sourceEl,
 *                     repairXY: Ext.fly(sourceEl).getXY(),
 *                     sourceStore: v.store,
 *                     draggedRecord: v.getRecord(sourceEl)
 *                 }
 *             }
 *         },
 *
 * //      Provide coordinates for the proxy to slide back to on failed drag.
 * //      This is the original XY coordinates of the draggable element captured
 * //      in the getDragData method.
 *         getRepairXY: function() {
 *             return this.dragData.repairXY;
 *         }
 *     });
 * });
 * </pre>
 * <p>See the →<code>ext.dd.DropZone</code> documentation for details about building a DropZone
 * which cooperates with this DragZone.</p>
 * @see #getDragData()
 * @see ext.dd.#Registry ext.dd.Registry
 * @see ext.view.DataView
 * @see ext.event.Event#getTarget()
 * @see ext.dd.DropZone
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragZone.html Original Ext JS documentation of 'Ext.dd.DragZone'
 */
public class DragZone extends DragSource {
  /**
   * Creates new DragZone.
   * @param el The container element or ID of it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragZone.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DragZone(el:*, config:DragZone = null) {
    super(undefined);
  }

  [ExtConfig]
  /**
   * True to register this container with the Scrollmanager for auto scrolling during
   * drag operations.
   * A →<code>ext.dd.ScrollManager</code> configuration may also be passed.
   * @see ext.dd.#ScrollManager ext.dd.ScrollManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragZone.html#cfg-containerScroll Original Ext JS documentation of 'containerScroll'
   */
  public native function get containerScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set containerScroll(value:*):void;

  [ExtConfig]
  /**
   * An element to register with the ScrollManager if →<code>containerScroll</code>
   * is set. Defaults to the drag element.
   * @see #containerScroll
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragZone.html#cfg-scrollEl Original Ext JS documentation of 'scrollEl'
   */
  public native function get scrollEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scrollEl(value:*):void;

  /**
   * Called when a mousedown occurs in this container. Looks in →<code>ext.dd.Registry</code>
   * for a valid target to drag based on the mouse down. Override this method to provide your own
   * lookup logic (e.g. finding a child by class name). Make sure your returned object
   * has a "ddel" attribute (with an HTML Element) for other functions to work.
   * @return The dragData
   * @see ext.dd.#Registry ext.dd.Registry
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragZone.html#method-getDragData Original Ext JS documentation of 'getDragData'
   */
  override public native function getDragData(e:Event):Object;

  [ArrayElementType("Number")]
  /**
   * Called before a repair of an invalid drop to get the XY to animate to.
   * By default returns the XY of this.dragData.ddel
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The mouse up event
   * @return The xy location (e.g. <code>[100, 200]</code>)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragZone.html#method-getRepairXY Original Ext JS documentation of 'getRepairXY'
   */
  public native function getRepairXY(e:Event):Array;

  /**
   * Called once drag threshold has been reached to initialize the proxy element.
   * By default, it clones the this.dragData.ddel
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param x The x position of the click on the dragged object
   * @param y The y position of the click on the dragged object
   * @return true to continue the drag, false to cancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragZone.html#method-onInitDrag Original Ext JS documentation of 'onInitDrag'
   */
  public native function onInitDrag(x:Number, y:Number):Boolean;
}
}