package ext.dd {
import ext.event.Event;

[Native("Ext.dd.DropTarget", require)]
/**
 * A simple class that provides the basic implementation needed to make any element a drop target
 * that can have draggable items dropped onto it. The drop has no effect until an implementation
 * of notifyDrop is provided.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html Original Ext JS documentation of 'Ext.dd.DropTarget'
 */
public class DropTarget extends DDTarget {
  /**
   * Creates new DropTarget.
   * @param el The container element or ID of it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DropTarget(el:*, config:DropTarget = null) {
    super(null, null, null);
  }

  [ExtConfig]
  /**
   * True to register this container with the ScrollManager for auto scrolling during
   * drag operations.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#cfg-containerScroll Original Ext JS documentation of 'containerScroll'
   */
  public native function get containerScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set containerScroll(value:Boolean):void;

  [ExtConfig]
  /**
   * A named drag drop group to which this object belongs. If a group is specified, then
   * this object will only interact with other drag drop objects in the same group.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#cfg-ddGroup Original Ext JS documentation of 'ddGroup'
   */
  public native function get ddGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ddGroup(value:String):void;

  [ExtConfig]
  /**
   * The CSS class returned to the drag source when drop is allowed.
   * @default Ext.baseCSSPrefix + 'dd-drop-ok'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#cfg-dropAllowed Original Ext JS documentation of 'dropAllowed'
   */
  public native function get dropAllowed():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropAllowed(value:String):void;

  [ExtConfig]
  /**
   * The CSS class returned to the drag source when drop is not allowed.
   * @default Ext.baseCSSPrefix + 'dd-drop-nodrop'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#cfg-dropNotAllowed Original Ext JS documentation of 'dropNotAllowed'
   */
  public native function get dropNotAllowed():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropNotAllowed(value:String):void;

  [ExtConfig]
  /**
   * The CSS class applied to the drop target element while the drag source is over it.
   * @default ""
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#cfg-overClass Original Ext JS documentation of 'overClass'
   */
  public native function get overClass():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overClass(value:String):void;

  /**
   * The function a →<code>ext.dd.DragSource</code> calls once to notify this drop target that
   * the dragged item has been dropped on it. This method removes any <code>→overClass</code> and returns
   * false, so you must provide an implementation that does something to process the drop event
   * and returns true so that the drag source's repair action does not run.
   * <p>You should <code>callParent</code> from an override of this method to ensure proper cleanup is
   * performed.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param source The drag source that was dragged over this drop target
   * @param e The event
   * @param data An object containing arbitrary data supplied by the drag source
   * @return False if the drop was invalid.
   * @see ext.dd.DragSource
   * @see #overClass
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#method-notifyDrop Original Ext JS documentation of 'notifyDrop'
   */
  public native function notifyDrop(source:DragSource, e:Event, data:Object):Boolean;

  /**
   * The function a →<code>ext.dd.DragSource</code> calls once to notify this drop target that the
   * source is now over the target. This default implementation adds the CSS class specified
   * by overClass (if any) to the drop element and returns the dropAllowed config value.
   * This method should be overridden if drop validation is required.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param source The drag source that was dragged over this drop target
   * @param e The event
   * @param data An object containing arbitrary data supplied by the drag source
   * @return status The CSS class that communicates the drop status back to the source
   * so that the underlying →<code>ext.dd.StatusProxy</code> can be updated
   * @see ext.dd.DragSource
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#method-notifyEnter Original Ext JS documentation of 'notifyEnter'
   * @see ext.dd.StatusProxy
   */
  public native function notifyEnter(source:DragSource, e:Event, data:Object):String;

  /**
   * The function a →<code>ext.dd.DragSource</code> calls once to notify this drop target
   * that the source has been dragged out of the target without dropping.
   * This default implementation simply removes the CSS class specified by <code>→overClass</code>
   * (if any) from the drop element.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param source The drag source that was dragged over this drop target
   * @param e The event
   * @param data An object containing arbitrary data supplied by the drag source
   * @see ext.dd.DragSource
   * @see #overClass
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#method-notifyOut Original Ext JS documentation of 'notifyOut'
   */
  public native function notifyOut(source:DragSource, e:Event, data:Object):void;

  /**
   * The function a →<code>ext.dd.DragSource</code> calls continuously while it is being dragged over
   * the target. This method will be called on every mouse movement while the drag source is over
   * the drop target. This default implementation simply returns the dropAllowed config value.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param source The drag source that was dragged over this drop target
   * @param e The event
   * @param data An object containing arbitrary data supplied by the drag source
   * @return status The CSS class that communicates the drop status back to the source
   * so that the underlying →<code>ext.dd.StatusProxy</code> can be updated
   * @see ext.dd.DragSource
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DropTarget.html#method-notifyOver Original Ext JS documentation of 'notifyOver'
   * @see ext.dd.StatusProxy
   */
  public native function notifyOver(source:DragSource, e:Event, data:Object):String;

  [ExtConfig]
  /**
   * Whether HTML5 drag and drop shall be enabled on this drop target.
   *
   * Defaults to false.
   */
  public native function get enableHtml5DD():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableHtml5DD(value:Boolean):void;
}
}