package ext.dd {
import ext.Base;
import ext.util.Region;

import js.Event;
import js.HTMLElement;

[Native]
/**
 * DragDropManager is a singleton that tracks the element interaction for
 * all DragDrop items in the window. Generally, you will not call
 * this class directly, but it does have helper methods that could
 * be useful in your DragDrop implementations.
 * <p>Type of singleton DragDropManager.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html Original Ext JS documentation of 'Ext.dd.DragDropManager'
 * @see ext.dd.#DragDropManager ext.dd.DragDropManager
 */
public class SDragDropManager extends Base {
  /**
   * In intersect mode, drag and drop interaction is defined by the
   * overlap of two or more drag and drop objects.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-INTERSECT Original Ext JS documentation of 'INTERSECT'
   */
  public native function get INTERSECT():Number;

  /**
   * In point mode, drag and drop interaction is defined by the
   * location of the cursor during the drag/drop
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-POINT Original Ext JS documentation of 'POINT'
   */
  public native function get POINT():Number;

  /**
   * The number of pixels that the mouse needs to move after the
   * mousedown before the drag is initiated. Default=8;
   * defaults to the same value used in the LongPress gesture so that drag cannot be
   * initiated if there is a possible pending longpress
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-clickPixelThresh Original Ext JS documentation of 'clickPixelThresh'
   */
  public native function get clickPixelThresh():Number;

  /**
   * @private
   */
  public native function set clickPixelThresh(value:Number):void;

  /**
   * Class to add to the <i>dragged element</i> (→<code>ext.dd.DragDrop.getDragEl()</code>) of a DragDrop instance.
   * @default Ext.baseCSSPrefix + 'dd-drag-current'
   * @see ext.dd.DragDrop#getDragEl()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-dragCls Original Ext JS documentation of 'dragCls'
   */
  public native function get dragCls():String;

  /**
   * The current drag and drop mode. Default: POINT
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-mode Original Ext JS documentation of 'mode'
   */
  public native function get mode():Number;

  /**
   * @private
   */
  public native function set mode(value:Number):void;

  /**
   * This config is only provided to provide old, usually unwanted drag/drop behaviour.
   * <p>From ExtJS 4.1.0 onwards, when drop targets are contained in floating, absolutely positioned
   * elements such as in <i>Windows</i> (→<code>ext.window.Window</code>), which may overlap each other,
   * <code>over</code> and <code>drop</code> events are only delivered to the topmost drop target at the mouse position.</p>
   * <p>If all targets below that in zIndex order should also receive notifications, set
   * <code>→notifyOccluded</code> to <code>true</code>.</p>
   * @default false
   * @see ext.window.Window
   * @see SDragDropManager#notifyOccluded
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-notifyOccluded Original Ext JS documentation of 'notifyOccluded'
   */
  public native function get notifyOccluded():Boolean;

  /**
   * @private
   */
  public native function set notifyOccluded(value:Boolean):void;

  [Deprecated(replacement="touchAction", since="6.2.0")]
  /**
   * <code>true</code> to invoke <code>preventDefault()</code> on all events during a drag (may be
   * mouse, touch, or pointer events depending on the platform).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-preventDefault Original Ext JS documentation of 'preventDefault'
   */
  public native function get preventDefault():Boolean;

  /**
   * @private
   */
  public native function set preventDefault(value:Boolean):void;

  [Deprecated(message="This property is deprecated\n", since="6.2.0")]
  /**
   * <code>true</code> to invoke <code>stopPropagation()</code> on all events during a drag (may be
   * mouse, touch, or pointer events depending on the platform).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-stopPropagation Original Ext JS documentation of 'stopPropagation'
   */
  public native function get stopPropagation():Boolean;

  /**
   * @private
   */
  public native function set stopPropagation(value:Boolean):void;

  /**
   * Set useCache to false if you want to force object the lookup of each
   * drag and drop linked element constantly during a drag.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#property-useCache Original Ext JS documentation of 'useCache'
   */
  public native function get useCache():Boolean;

  /**
   * @private
   */
  public native function set useCache(value:Boolean):void;

  /**
   * Helper function for getting the best match from the list of drag
   * and drop objects returned by the drag and drop events when we are
   * in INTERSECT mode. It returns either the first object that the
   * cursor is over, or the object that has the greatest overlap with
   * the dragged element.
   * @param dds The array of drag and drop objects
   * targeted
   * @return The best single match
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-getBestMatch Original Ext JS documentation of 'getBestMatch'
   */
  public native function getBestMatch(dds:Array):DragDrop;

  /**
   * Returns the style property for the DOM element (i.e.,
   * document.getElById(id).style)
   * @param id the id of the element to get
   * @return The style property of the element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-getCss Original Ext JS documentation of 'getCss'
   */
  public native function getCss(id:String):Object;

  /**
   * Returns the DragDrop instance for a given id
   * @param id the id of the DragDrop object
   * @return the drag drop object, null if it is not found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-getDDById Original Ext JS documentation of 'getDDById'
   */
  public native function getDDById(id:String, force:Boolean):DragDrop;

  [Deprecated(message="Use Ext.lib.Ext.getDom() instead.\n", since="6.5.0")]
  /**
   * Returns the actual DOM element
   * @param id the id of the elment to get
   * @return The element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-getElement Original Ext JS documentation of 'getElement'
   */
  public native function getElement(id:String):Object;

  /**
   * Returns a Region object containing the drag and drop element's position
   * and size, including the padding configured for it
   * @param oDD the drag and drop object to get the location for.
   * @return a Region object representing the total area
   * the element occupies, including any padding
   * the instance is configured for.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-getLocation Original Ext JS documentation of 'getLocation'
   */
  public native function getLocation(oDD:DragDrop):Region;

  [ArrayElementType("ext.dd.DragDrop")]
  /**
   * Returns the drag and drop instances that are in all groups the
   * passed in instance belongs to.
   * @param p_oDD the obj to get related data for
   * @param bTargetsOnly if true, only return targetable objs
   * @return the related instances
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-getRelated Original Ext JS documentation of 'getRelated'
   */
  public native function getRelated(p_oDD:DragDrop, bTargetsOnly:Boolean):Array;

  /**
   * Utility function to determine if a given element has been
   * registered as a drag drop item.
   * @param id the element id to check
   * @return true if this element is a DragDrop item,
   * false otherwise
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-isDragDrop Original Ext JS documentation of 'isDragDrop'
   */
  public native function isDragDrop(id:String):Boolean;

  /**
   * Utility function to determine if a given element has been
   * registered as a drag drop handle for the given Drag Drop object.
   * @param sDDId the element id to check
   * @return true if this element is a DragDrop handle, false
   * otherwise
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-isHandle Original Ext JS documentation of 'isHandle'
   */
  public native function isHandle(sDDId:String, sHandleId:String):Boolean;

  /**
   * Returns true if the specified dd target is a legal target for
   * the specifice drag obj
   * @param oDD the drag obj
   * @param oTargetDD the target
   * @return true if the target is a legal target for the
   * dd obj
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-isLegalTarget Original Ext JS documentation of 'isLegalTarget'
   */
  public native function isLegalTarget(oDD:DragDrop, oTargetDD:DragDrop):Boolean;

  /**
   * Is drag and drop locked?
   * @return True if drag and drop is locked, false otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-isLocked Original Ext JS documentation of 'isLocked'
   */
  public native function isLocked():Boolean;

  /**
   * My goal is to be able to transparently determine if an object is
   * typeof DragDrop, and the exact subclass of DragDrop. typeof
   * returns "object", oDD.constructor.toString() always returns
   * "DragDrop" and not the name of the subclass. So for now it just
   * evaluates a well-known variable in DragDrop.
   * @param oDD The object to evaluate
   * @return true if typeof oDD = DragDrop
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-isTypeOfDD Original Ext JS documentation of 'isTypeOfDD'
   */
  public native function isTypeOfDD(oDD:Object):Boolean;

  /**
   * Lock all drag and drop functionality
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-lock Original Ext JS documentation of 'lock'
   */
  public native function lock():void;

  /**
   * Refreshes the cache of the top-left and bottom-right points of the
   * drag and drop objects in the specified group(s). This is in the
   * format that is stored in the drag and drop instance, so typical
   * usage is:
   * <pre>
   * Ext.dd.DragDropManager.refreshCache(ddinstance.groups);
   * </pre>
   * <p>Alternatively:</p>
   * <pre>
   * Ext.dd.DragDropManager.refreshCache({group1:true, group2:true});
   * </pre>
   * <p>TODO: this really should be an indexed array. Alternatively this
   * method could accept both.</p>
   * @param groups an associative array of groups to refresh
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-refreshCache Original Ext JS documentation of 'refreshCache'
   */
  public native function refreshCache(groups:Object):void;

  /**
   * Each DragDrop instance must be registered with the DragDropManager.
   * This is executed in DragDrop.init()
   * @param oDD the DragDrop object to register
   * @param sGroup the name of the group this element belongs to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-regDragDrop Original Ext JS documentation of 'regDragDrop'
   */
  public native function regDragDrop(oDD:DragDrop, sGroup:String):void;

  /**
   * Each DragDrop handle element must be registered. This is done
   * automatically when executing DragDrop.setHandleElId()
   * @param sDDId the DragDrop id this element is a handle for
   * @param sHandleId the id of the element that is the drag
   * handle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-regHandle Original Ext JS documentation of 'regHandle'
   */
  public native function regHandle(sDDId:String, sHandleId:String):void;

  /**
   * Fired when either the drag pixel threshold or the mousedown hold
   * time threshold has been met.
   * @param x the X position of the original mousedown
   * @param y the Y position of the original mousedown
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-startDrag Original Ext JS documentation of 'startDrag'
   */
  public native function startDrag(x:Number, y:Number):void;

  /**
   * Utility to stop event propagation and event default, if these
   * features are turned on.
   * @param e the event as returned by this.getEvent()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-stopEvent Original Ext JS documentation of 'stopEvent'
   */
  public native function stopEvent(e:Event):void;

  /**
   * Unlock all drag and drop functionality
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-unlock Original Ext JS documentation of 'unlock'
   */
  public native function unlock():void;

  /**
   * This checks to make sure an element exists and is in the DOM. The
   * main purpose is to handle cases where innerHTML is used to remove
   * drag and drop objects from the DOM.
   * @param el the element to check
   * @return true if the element looks usable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.DragDropManager.html#method-verifyEl Original Ext JS documentation of 'verifyEl'
   */
  public native function verifyEl(el:HTMLElement):Boolean;
}
}