package ext.dd {
import ext.Base;

import ext.event.Event;

[Native]
/**
 * Provides easy access to all drag drop components that are registered on a page.
 * Items can be retrieved either directly by DOM node id, or by passing in the drag drop event
 * that occurred and looking up the event target.
 * <p>Type of singleton Registry.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.Registry.html Original Ext JS documentation of 'Ext.dd.Registry'
 * @see ext.dd.#Registry ext.dd.Registry
 */
public class SRegistry extends Base {
  /**
   * Returns the handle registered for a DOM Node by id
   * @param id The DOM node or id to look up
   * @return handle The custom handle data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.Registry.html#method-getHandle Original Ext JS documentation of 'getHandle'
   */
  public native function getHandle(id:*):Object;

  /**
   * Returns the handle that is registered for the DOM node that is the target of the event
   * @param e The event
   * @return handle The custom handle data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.Registry.html#method-getHandleFromEvent Original Ext JS documentation of 'getHandleFromEvent'
   */
  public native function getHandleFromEvent(e:Event):Object;

  /**
   * Returns a custom data object that is registered for a DOM node by id
   * @param id The DOM node or id to look up
   * @return data The custom data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.Registry.html#method-getTarget Original Ext JS documentation of 'getTarget'
   */
  public native function getTarget(id:*):Object;

  /**
   * Returns a custom data object that is registered for the DOM node that is the target
   * of the event
   * @param e The event
   * @return data The custom data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.Registry.html#method-getTargetFromEvent Original Ext JS documentation of 'getTargetFromEvent'
   */
  public native function getTargetFromEvent(e:Event):Object;

  /**
   * Registers a drag drop element.
   * @param el The id or DOM node to register
   * @param data An custom data object that will be passed between the elements that are
   * involved in drag drop operations. You can populate this object with any arbitrary properties
   * that your own code knows how to interpret, plus there are some specific properties known to
   * the Registry that should be populated in the data object (if applicable):
   * <ul>
   * <li><code>handles:Array</code> (optional) —
   * Array of DOM nodes that trigger dragging for the element
   * being registered.
   * </li>
   * <li><code>isHandle:Boolean</code> (optional) —
   * True if the element passed in triggers dragging itself,
   * else false.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.Registry.html#method-register Original Ext JS documentation of 'register'
   */
  public native function register(el:*, data:Object):void;

  /**
   * Unregister a drag drop element
   * @param el The id or DOM node to unregister
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.Registry.html#method-unregister Original Ext JS documentation of 'unregister'
   */
  public native function unregister(el:*):void;
}
}