package ext.dd {
import ext.Base;

[Native]
/**
 * Provides automatic scrolling of overflow regions in the page during drag operations.
 * <p>The ScrollManager configs will be used as the defaults for any scroll container registered
 * with it, but you can also override most of the configs per scroll container by adding a
 * ddScrollConfig object to the target element that contains these properties: →<code>hthresh</code>,
 * →<code>vthresh</code>, →<code>increment</code> and →<code>frequency</code>. Example usage:</p>
 * <pre>
 * var el = Ext.get('scroll-ct');
 * el.ddScrollConfig = {
 *     vthresh: 50,
 *     hthresh: -1,
 *     frequency: 100,
 *     increment: 200
 * };
 * Ext.dd.ScrollManager.register(el);
 * </pre>
 * <p>Note: This class is designed to be used in "Point Mode</p>
 * <p>Type of singleton ScrollManager.</p>
 * @see SScrollManager#hthresh
 * @see SScrollManager#vthresh
 * @see SScrollManager#increment
 * @see SScrollManager#frequency
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html Original Ext JS documentation of 'Ext.dd.ScrollManager'
 * @see ext.dd.#ScrollManager ext.dd.ScrollManager
 */
public class SScrollManager extends Base implements IDDScrollConfig {
  /**
   * The animation duration in seconds - MUST BE less than →<code>frequency</code>!
   * @default 0.4
   * @see #frequency
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#property-animDuration Original Ext JS documentation of 'animDuration'
   */
  public native function get animDuration():Number;

  /**
   * @private
   */
  public native function set animDuration(value:Number):void;

  /**
   * True to animate the scroll
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#property-animate Original Ext JS documentation of 'animate'
   */
  public native function get animated():Boolean;

  /**
   * @private
   */
  public native function set animated(value:Boolean):void;

  /**
   * The named drag drop <i>group</i> (→<code>ext.dd.DragSource.ddGroup</code>) to which this container belongs.
   * If a ddGroup is specified, then container scrolling will only occur when a dragged object
   * is in the same ddGroup.
   * @default undefined
   * @see ext.dd.DragSource#ddGroup
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#property-ddGroup Original Ext JS documentation of 'ddGroup'
   */
  public native function get ddGroup():String;

  /**
   * @private
   */
  public native function set ddGroup(value:String):void;

  /**
   * The frequency of scrolls in milliseconds
   * @default 500
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#property-frequency Original Ext JS documentation of 'frequency'
   */
  public native function get frequency():Number;

  /**
   * @private
   */
  public native function set frequency(value:Number):void;

  /**
   * The number of pixels from the right or left edge of a container the pointer needs to be
   * to trigger scrolling
   * @default 25 &#42; (window.devicePixelRatio || 1)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#property-hthresh Original Ext JS documentation of 'hthresh'
   */
  public native function get hthresh():Number;

  /**
   * @private
   */
  public native function set hthresh(value:Number):void;

  /**
   * The number of pixels to scroll in each scroll increment
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#property-increment Original Ext JS documentation of 'increment'
   */
  public native function get increment():Number;

  /**
   * @private
   */
  public native function set increment(value:Number):void;

  /**
   * The number of pixels from the top or bottom edge of a container the pointer needs to be
   * to trigger scrolling
   * @default 25 &#42; (window.devicePixelRatio || 1)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#property-vthresh Original Ext JS documentation of 'vthresh'
   */
  public native function get vthresh():Number;

  /**
   * @private
   */
  public native function set vthresh(value:Number):void;

  /**
   * Manually trigger a cache refresh.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#method-refreshCache Original Ext JS documentation of 'refreshCache'
   */
  public native function refreshCache():void;

  /**
   * Registers new overflow element(s) to auto scroll
   * @param el The id of or the element to be scrolled or an array of either
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#method-register Original Ext JS documentation of 'register'
   */
  public native function register(el:*):void;

  /**
   * Unregisters overflow element(s) so they are no longer scrolled
   * @param el The id of or the element to be removed or an array of either
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html#method-unregister Original Ext JS documentation of 'unregister'
   */
  public native function unregister(el:*):void;
}
}