package ext.dd {

[Native("Ext.dd.ScrollManager", require)]
/**
 * Provides automatic scrolling of overflow regions in the page during drag operations.
 * <p>The ScrollManager configs will be used as the defaults for any scroll container registered
 * with it, but you can also override most of the configs per scroll container by adding a
 * ddScrollConfig object to the target element that contains these properties: →<code>hthresh</code>,
 * →<code>vthresh</code>, →<code>increment</code> and →<code>frequency</code>. Example usage:</p>
 * <pre>
 * var el = Ext.get('scroll-ct');
 * el.ddScrollConfig = {
 *     vthresh: 50,
 *     hthresh: -1,
 *     frequency: 100,
 *     increment: 200
 * };
 * Ext.dd.ScrollManager.register(el);
 * </pre>
 * <p>Note: This class is designed to be used in "Point Mode</p>
 * @see SScrollManager#hthresh
 * @see SScrollManager#vthresh
 * @see SScrollManager#increment
 * @see SScrollManager#frequency
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.ScrollManager.html Original Ext JS documentation of 'Ext.dd.ScrollManager'
 */
public const ScrollManager:SScrollManager = new SScrollManager;
}