package ext.dd {
import ext.Component;
import ext.dom.Element;

[Native("Ext.dd.StatusProxy", require)]
/**
 * A specialized floating Component that supports a drop status icon and auto-repair.
 * This is the default drag proxy used by all Ext.dd components.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html Original Ext JS documentation of 'Ext.dd.StatusProxy'
 */
public class StatusProxy extends Component {
  /**
   * Creates new StatusProxy.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function StatusProxy(config:StatusProxy = null) {
    super();
  }

  [ExtConfig]
  /**
   * The CSS class to apply to the status element when drop is allowed.
   * @default Ext.baseCSSPrefix + 'dd-drop-ok'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#cfg-dropAllowed Original Ext JS documentation of 'dropAllowed'
   */
  public native function get dropAllowed():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropAllowed(value:String):void;

  [ExtConfig]
  /**
   * The CSS class to apply to the status element when drop is not allowed.
   * @default Ext.baseCSSPrefix + 'dd-drop-nodrop'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#cfg-dropNotAllowed Original Ext JS documentation of 'dropNotAllowed'
   */
  public native function get dropNotAllowed():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropNotAllowed(value:String):void;

  /**
   * Returns the ghost element
   * @return el
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-getGhost Original Ext JS documentation of 'getGhost'
   */
  public native function getGhost():Element;

  /**
   * Hides the proxy
   * @param animateTarget <b>only valid for
   * →<code>floating</code> Components such as →<code>ext.window.Window</code>s or
   * →<code>ext.tip.ToolTip</code>s, or regular Components which have been configured with
   * <code>floating: true</code>.</b>. The target to which the Component should animate while hiding.
   * @default null
   * @param callback A callback function to call after the Component is hidden.
   * @param scope The scope (<code>this</code> reference) in which the callback is executed.
   * Defaults to this Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-hide Original Ext JS documentation of 'hide'
   * @see #floating
   * @see ext.window.Window
   * @see ext.tip.ToolTip
   */
  override public native function hide(animateTarget:Object = null, callback:Function = null, scope:Object = null):void;

  /**
   * Causes the proxy to return to its position of origin via an animation.
   * Should be called after an invalid drop operation by the item being dragged.
   * @param xy The XY position of the element ([x, y])
   * @param callback The function to call after the repair is complete.
   * @param scope The scope (<code>this</code> reference) in which the callback function
   * is executed. Defaults to the browser window.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-repair Original Ext JS documentation of 'repair'
   */
  public native function repair(xy:Array, callback:Function, scope:Object):void;

  /**
   * Resets the status indicator to the default dropNotAllowed value
   * @param clearGhost True to also remove all content from the ghost,
   * false to preserve it
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-reset Original Ext JS documentation of 'reset'
   */
  public native function reset(clearGhost:Boolean):void;

  /**
   * Updates the proxy's visual element to indicate the status of whether or not drop is allowed
   * over the current target element.
   * @param cssClass The css class for the new drop status indicator image
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-setStatus Original Ext JS documentation of 'setStatus'
   */
  public native function setStatus(cssClass:String):void;

  /**
   * Stops the repair animation if it's currently running
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-stop Original Ext JS documentation of 'stop'
   */
  public native function stop():void;

  /**
   * Force the Element to sync its shadow and shim positions
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-sync Original Ext JS documentation of 'sync'
   */
  public native function sync():void;

  /**
   * Updates the contents of the ghost element
   * @param htmlOrData If this component has been configured with a
   * template via the tpl config then it will use this argument as data to populate the
   * template. If this component was not configured with a template, the components
   * content area will be updated via Ext.Element update.
   * @param loadScripts Only legitimate when using the <code>→html</code>
   * configuration. Causes embedded script tags to be executed. Inline source will be executed
   * with this Component as the scope (<code>this</code> reference).
   * @default false
   * @param callback Only legitimate when using the <code>→html</code> configuration.
   * Callback to execute when scripts have finished loading.
   * @param scriptScope (Default `this`) The scope (<code>this</code> reference) in which to
   * execute <i>inline</i> script elements content. Scripts with a <code>src</code> attribute cannot
   * be executed with this scope.
   * @default this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dd.StatusProxy.html#method-update Original Ext JS documentation of 'update'
   * @see #html
   */
  override public native function update(htmlOrData:*, loadScripts:Boolean = false, callback:Function = null, scriptScope:Object = null):void;
}
}