package ext.direct {
import ext.Base;

[Native("Ext.direct.Event", require)]
/**
 * Base class for all Ext Direct events. An event is
 * created after some kind of interaction with the server.
 * The event class is essentially just a data structure
 * to hold a Direct response.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Event.html Original Ext JS documentation of 'Ext.direct.Event'
 */
public class DirectEvent extends Base {
  /**
   * Creates new Event.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Event.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function DirectEvent(config:DirectEvent = null) {
    super();
  }

  /**
   * Return the raw data for this event.
   * @return The data from the event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Event.html#method-getData Original Ext JS documentation of 'getData'
   */
  public native function getData():*;

  /**
   * Return the name for this event.
   * @return The name of event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Event.html#method-getName Original Ext JS documentation of 'getName'
   */
  public native function getName():String;
}
}