package ext.direct {

[Native("Ext.direct.Manager", require)]
/**
 * Ext Direct aims to streamline communication between the client and server
 * by providing a single interface that reduces the amount of common code
 * typically required to validate data and handle returned data packets
 * (reading data, error conditions, etc).
 * <p>The <code>Ext.direct</code> namespace includes several classes for a closer integration
 * with the server-side. The Ext.data namespace also includes classes for working
 * with Ext.data.Stores which are backed by data from an Ext Direct method.</p>
 * <p><b>Specification</b></p>
 * <p>For additional information consult the <a href="http://sencha.com/products/extjs/extdirect">Ext Direct Specification</a>.</p>
 * <p><b>Providers</b></p>
 * <p>Ext Direct uses a provider architecture, where one or more providers are used
 * to transport data to and from the server. There are several providers that exist
 * in the core at the moment:</p>
 * <ul>
 * <li>→<code>ext.direct.JsonProvider</code> for simple JSON operations</li>
 * <li>→<code>ext.direct.PollingProvider</code> for repeated requests</li>
 * <li>→<code>ext.direct.RemotingProvider</code> exposes server side to the client.</li>
 * </ul>
 * <p>A provider does not need to be invoked directly, providers are added via
 * <i>addProvider</i> (→<code>ext.direct.DirectManager</code>). RemotingProviders' API declarations
 * can also be loaded with <i>loadProvider</i> (→<code>ext.direct.DirectManager</code>), with
 * Provider instance created automatically after successful retrieval.</p>
 * <p><b>Router</b></p>
 * <p>Ext Direct RemotingProviders utilize a "router" on the server to direct
 * requests from the client to the appropriate server-side method. Because
 * the Ext Direct API is platform-agnostic, you could completely swap out
 * a Java based server solution and replace it with one that uses C#
 * without changing the client side JavaScript at all, or vice versa.</p>
 * <p><b>Server side events</b></p>
 * <p>Custom events from the server may be handled by the client by adding listeners, for example:</p>
 * <pre>
 * {"type":"event","name":"message","data":"Successfully polled at: 11:19:30 am"}
 *
 * // add a handler for a 'message' event sent by the server
 * Ext.direct.Manager.on('message', function(e){
 *     out.append(String.format('&lt;p&gt;&lt;i&gt;{0}&lt;/i&gt;&lt;/p&gt;', e.data));
 *     out.el.scrollTo('t', 100000, true);
 * });
 * </pre>
 * @see ext.direct.JsonProvider
 * @see ext.direct.PollingProvider
 * @see ext.direct.RemotingProvider
 * @see ext.direct.#DirectManager ext.direct.DirectManager
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html Original Ext JS documentation of 'Ext.direct.Manager'
 */
public const DirectManager:SDirectManager = new SDirectManager;
}