package ext.direct {

[Native("Ext.direct.JsonProvider", require)]
/**
 * A base provider for communicating using JSON. This is an abstract class
 * and should not be instanced directly.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.JsonProvider.html Original Ext JS documentation of 'Ext.direct.JsonProvider'
 */
public class JsonProvider extends Provider {
  /**
   * @param config @inheritDoc
   */
  public function JsonProvider(config:JsonProvider = null) {
    super();
  }

  /**
   * Create an event from a response object
   * @param response Response object
   * @return The event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.JsonProvider.html#method-createEvent Original Ext JS documentation of 'createEvent'
   */
  public native function createEvent(response:Object):DirectEvent;

  [ArrayElementType("ext.direct.DirectEvent")]
  /**
   * Creates a set of events based on the XHR response
   * @param response The XHR response
   * @return An array of Ext.direct.Event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.JsonProvider.html#method-createEvents Original Ext JS documentation of 'createEvents'
   */
  public native function createEvents(response:Object):Array;
}
}