package ext.direct {

[Native("Ext.direct.PollingProvider", require)]
/**
 * @see ext.direct.events.PollingProviderEvent.BEFORE_POLL
 * @eventType ext.direct.events.PollingProviderEvent.BEFORE_POLL
 */
[Event(name='onBeforePoll', type='ext.direct.events.PollingProviderEvent')]
/**
 * @see ext.direct.events.PollingProviderEvent.POLL
 * @eventType ext.direct.events.PollingProviderEvent.POLL
 */
[Event(name='onPoll', type='ext.direct.events.PollingProviderEvent')]
/**
 * Provides for repetitive polling of the server at distinct <i>intervals</i> (→<code>interval</code>).
 * The initial request for data originates from the client, and then is responded to by the
 * server.
 * <p>Configuration for the PollingProvider can be generated by the server-side
 * API portion of the Ext Direct stack.</p>
 * <p>An instance of PollingProvider may be created directly via the new keyword or by simply
 * specifying <code>type = 'polling'</code>. For example:</p>
 * <pre>
 *  var pollA = new Ext.direct.PollingProvider({
 *      type:'polling',
 *      url: 'php/pollA.php',
 *  });
 *  Ext.direct.Manager.addProvider(pollA);
 *  pollA.disconnect();
 *
 *  Ext.direct.Manager.addProvider({
 *      type:'polling',
 *      url: 'php/pollB.php',
 *      id: 'pollB-provider'
 *  });
 *  var pollB = Ext.direct.Manager.getProvider('pollB-provider');
 * </pre>
 * @see #interval
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html Original Ext JS documentation of 'Ext.direct.PollingProvider'
 */
public class PollingProvider extends JsonProvider {
  /**
   * @param config @inheritDoc
   */
  public function PollingProvider(config:PollingProvider = null) {
    super();
  }

  [ExtConfig]
  /**
   * An object containing properties which are to be sent as parameters on every
   * polling request. Note that if baseParams are set and →<code>url</code> parameter
   * is an URL string, poll requests will use POST method instead of default GET.
   * @see #url
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html#cfg-baseParams Original Ext JS documentation of 'baseParams'
   */
  public native function get baseParams():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseParams(value:Object):void;

  [ExtConfig]
  /**
   * How often to poll the server-side in milliseconds. Defaults to every 3 seconds.
   * @default 3000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html#cfg-interval Original Ext JS documentation of 'interval'
   */
  public native function get interval():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set interval(value:Number):void;

  [ExtConfig]
  /**
   * Ext Direct method to use for polling. If a method name is provided as a string,
   * the actual function will not be resolved until the first time this provider
   * is connected.
   * <p>The method should accept named arguments and will be passed →<code>baseParams</code>
   * if set.</p>
   * @see #baseParams
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html#cfg-pollFn Original Ext JS documentation of 'pollFn'
   */
  public native function get pollFn():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pollFn(value:*):void;

  [ExtConfig]
  /**
   * The timeout to use for each request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html#cfg-timeout Original Ext JS documentation of 'timeout'
   */
  public native function get timeout():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  [Deprecated(replacement="url", since="5.1.0")]
  [ExtConfig]
  /**
   * The url which the PollingProvider should contact with each request. This can also be
   * an imported Ext Direct method which will be passed baseParams as named arguments.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html#cfg-url Original Ext JS documentation of 'url'
   */
  public native function get url():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set url(value:*):void;
}
}