package ext.direct {
import ext.mixin.Observable;

[Native("Ext.direct.Provider", require)]
/**
 * @see ext.direct.events.ProviderEvent.CONNECT
 * @eventType ext.direct.events.ProviderEvent.CONNECT
 */
[Event(name='onConnect', type='ext.direct.events.ProviderEvent')]
/**
 * @see ext.direct.events.Provider_eEvent.DATA
 * @eventType ext.direct.events.Provider_eEvent.DATA
 */
[Event(name='onData', type='ext.direct.events.Provider_eEvent')]
/**
 * @see ext.direct.events.ProviderEvent.DISCONNECT
 * @eventType ext.direct.events.ProviderEvent.DISCONNECT
 */
[Event(name='onDisconnect', type='ext.direct.events.ProviderEvent')]
/**
 * @see ext.direct.events.Provider_eEvent.EXCEPTION
 * @eventType ext.direct.events.Provider_eEvent.EXCEPTION
 */
[Event(name='onException', type='ext.direct.events.Provider_eEvent')]
/**
 * Ext.direct.Provider is an abstract class meant to be extended.
 * <p>For example Ext JS implements the following subclasses:</p>
 * <pre>
 * Provider
 * |
 * +---JsonProvider
 *     |
 *     +---PollingProvider
 *     |
 *     +---RemotingProvider
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html Original Ext JS documentation of 'Ext.direct.Provider'
 */
public class Provider extends Observable {
  /**
   * Check if the passed configuration object contains enough
   * information to construct a Provider.
   * @return <code>true</code> if config is sufficient, <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#static-method-checkConfig Original Ext JS documentation of 'checkConfig'
   */
  public static native function checkConfig(config:Object):Boolean;

  /**
   * @param config @inheritDoc
   */
  public function Provider(config:Provider = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * An object containing default headers for every Ajax request made by this Provider.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#cfg-headers Original Ext JS documentation of 'headers'
   * @see #getHeaders()
   * @see #setHeaders()
   */
  public native function get headers():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set headers(value:Object):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The unique id of the provider (defaults to an <i>auto-assigned id</i> (→<code>ext.Ext.id()</code>)).
   * You should assign an id if you need to be able to access the provider later and you do
   * not have an object reference available, for example:
   * <pre>
   *  Ext.direct.Manager.addProvider({
   *      type: 'polling',
   *      url:  'php/poll.php',
   *      id:   'poll-provider'
   *  });
   *
   *  var p = →<code>ext.direct.DirectManager</code>.→<code>ext.direct.DirectManager.getProvider()</code>('poll-provider');
   *
   *  p.disconnect();
   * </pre>
   * @see ext.SExt#id() ext.Ext.id()
   * @see ext.direct.#DirectManager ext.direct.DirectManager
   * @see ext.direct.SDirectManager#getProvider() ext.direct.DirectManager.getProvider()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   */
  public native function get id():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set id(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * List of Provider events that should be relayed by →<code>ext.direct.DirectManager</code>.
   * 'data' event is always relayed.
   * @see ext.direct.#DirectManager ext.direct.DirectManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#cfg-relayedEvents Original Ext JS documentation of 'relayedEvents'
   */
  public native function get relayedEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set relayedEvents(value:Array):void;

  /**
   * Connect the provider and start its service.
   * Provider will fire <code>connect</code> event upon successful connection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#method-connect Original Ext JS documentation of 'connect'
   */
  public native function connect():void;

  /**
   * Disconnect the provider and stop its service.
   * Provider will fire <code>disconnect</code> event upon successful disconnect.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#method-disconnect Original Ext JS documentation of 'disconnect'
   */
  public native function disconnect(force:*):void;

  /**
   * Do connection setup. This is a template method.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#method-doConnect Original Ext JS documentation of 'doConnect'
   */
  protected native function doConnect():void;

  /**
   * Do connection teardown. This is a template method.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#method-doDisconnect Original Ext JS documentation of 'doDisconnect'
   */
  protected native function doDisconnect():void;

  /**
   * Returns the value of <code>headers</code>.
   * @see #headers
   */
  public native function getHeaders():Object;

  /**
   * Returns whether or not the server-side is currently connected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#method-isConnected Original Ext JS documentation of 'isConnected'
   */
  public native function isConnected():void;

  /**
   * Sets the value of <code>headers</code>.
   * @param headers The new value.
   * @see #headers
   */
  public native function setHeaders(headers:Object):void;
}
}