package ext.direct {

[Native("Ext.direct.RemotingEvent", require)]
/**
 * An event that is fired when data is received from a
 * →<code>ext.direct.RemotingProvider</code>. Contains a method to the
 * related transaction for the direct request, see →<code>getTransaction()</code>
 * @see ext.direct.RemotingProvider
 * @see #getTransaction()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingEvent.html Original Ext JS documentation of 'Ext.direct.RemotingEvent'
 */
public class RemotingEvent extends DirectEvent {
  /**
   * @param config @inheritDoc
   */
  public function RemotingEvent(config:RemotingEvent = null) {
    super();
  }

  /**
   * Get the transaction associated with this event.
   * @return The transaction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingEvent.html#method-getTransaction Original Ext JS documentation of 'getTransaction'
   */
  public native function getTransaction():Transaction;
}
}