package ext.direct {

[Native("Ext.direct.RemotingProvider", require)]
/**
 * @see ext.direct.events.RemotingProvider_transaction_metaEvent.BEFORE_CALL
 * @eventType ext.direct.events.RemotingProvider_transaction_metaEvent.BEFORE_CALL
 */
[Event(name='onBeforeCall', type='ext.direct.events.RemotingProvider_transaction_metaEvent')]
/**
 * @see ext.direct.events.RemotingProvider_event_transactionEvent.BEFORE_CALLBACK
 * @eventType ext.direct.events.RemotingProvider_event_transactionEvent.BEFORE_CALLBACK
 */
[Event(name='onBeforeCallback', type='ext.direct.events.RemotingProvider_event_transactionEvent')]
/**
 * @see ext.direct.events.RemotingProvider_transaction_metaEvent.CALL
 * @eventType ext.direct.events.RemotingProvider_transaction_metaEvent.CALL
 */
[Event(name='onCall', type='ext.direct.events.RemotingProvider_transaction_metaEvent')]
/**
 * The →<code>ext.direct.RemotingProvider</code> exposes access to
 * server side methods on the client (a remote procedure call (RPC) type of
 * connection where the client can initiate a procedure on the server).
 * <p>This allows for code to be organized in a fashion that is maintainable,
 * while providing a clear path between client and server, something that is
 * not always apparent when using URLs.</p>
 * <p>To accomplish this the server-side needs to describe what classes and methods
 * are available on the client-side. This configuration will typically be
 * outputted by the server-side Ext Direct stack when the API description is built.</p>
 * @see ext.direct.RemotingProvider
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html Original Ext JS documentation of 'Ext.direct.RemotingProvider'
 */
public class RemotingProvider extends JsonProvider {
  /**
   * @param config @inheritDoc
   */
  public function RemotingProvider(config:RemotingProvider = null) {
    super();
  }

  [ExtConfig]
  /**
   * Object literal defining the server side actions and methods. For example, if
   * the Provider is configured with:
   * <pre>
   *  // each property within the 'actions' object represents a server side Class
   *  actions: {
   *      // array of methods in each server side Class to be stubbed out on client
   *      TestAction: [{
   *          name: 'doEcho',   // stub method will be TestAction.doEcho
   *          len:  1,
   *          batched: false    // always send requests immediately for this method
   *      }, {
   *          name: 'multiply', // name of method
   *          len:  2           // The number of parameters that will be used to create an
   *                            // array of data to send to the server side function.
   *      }, {
   *          name: 'doForm',
   *          formHandler: true // tells the client that this method handles form calls
   *      }],
   *
   *      // These methods will be created in nested namespace TestAction.Foo
   *      'TestAction.Foo': [{
   *          name: 'ordered',  // stub method will be TestAction.Foo.ordered
   *          len:  1
   *      }, {
   *          name: 'noParams', // this method does not accept any parameters
   *          len:  0
   *      }, {
   *          name: 'named',    // stub method will be TestAction.Foo.named
   *          params: ['foo', 'bar']    // parameters are passed by name
   *      }, {
   *          name: 'namedNoStrict',
   *          params: [],       // this method accepts parameters by name
   *          strict: false     // but does not check if they are required
   *                            // and will pass any to the server side
   *      }]
   *  }
   * </pre>
   * <p>Note that starting with 4.2, dotted Action names will generate nested objects.
   * If you wish to reverse to previous behavior, set →<code>disableNestedActions</code>
   * to <code>true</code>.</p>
   * <p>In the following example a <i>client side</i> handler is used to call the
   * server side method "multiply" in the server-side "TestAction" Class:</p>
   * <pre>
   *  TestAction.multiply(
   *      // pass two arguments to server, so specify len=2
   *      2, 4,
   *
   *      // callback function after the server is called
   *      //  result: the result returned by the server
   *      //       e: Ext.direct.RemotingEvent object
   *      // success: true or false
   *      // options: options to be applied to method call and passed to callback
   *      function (result, e, success, options) {
   *          var t, action, method;
   *
   *          t = e.getTransaction();
   *          action = t.action; // server side Class called
   *          method = t.method; // server side method called
   *
   *          if (e.status) {
   *              var answer = Ext.encode(result); // 8
   *          }
   *          else {
   *              var msg = e.message; // failure message
   *          }
   *      },
   *
   *      // Scope to call the callback in (optional)
   *      window,
   *
   *      // Options to apply to this method call. This can include
   *      // Ajax.request() options; only `→<code>timeout</code>` is supported at this time.
   *      // When timeout is set for a method call, it will be executed immediately
   *      // without buffering.
   *      // The same options object is passed to the callback so it's possible
   *      // to "forward" some data when needed.
   *      {
   *          timeout: 60000, // milliseconds
   *          foo: 'bar'
   *      }
   *  );
   * </pre>
   * <p>In the example above, the server side "multiply" function will be passed two
   * arguments (2 and 4). The "multiply" method should return the value 8 which will be
   * available as the <code>result</code> in the callback example above.</p>
   * @see #disableNestedActions
   * @see #timeout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-actions Original Ext JS documentation of 'actions'
   */
  public native function get actions():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set actions(value:Object):void;

  [ExtConfig]
  /**
   * The maximum number of requests to batch together. By default, an unlimited number
   * of requests will be batched. This option will allow to wait only for a certain
   * number of Direct method calls before dispatching a request to the server, even if
   * →<code>enableBuffer</code> timeout has not yet expired.
   * <p>Note that this option does nothing if →<code>enableBuffer</code> is set to <code>false</code>.</p>
   * @default Number.MAX_VALUE
   * @see #enableBuffer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-bufferLimit Original Ext JS documentation of 'bufferLimit'
   */
  public native function get bufferLimit():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bufferLimit(value:Number):void;

  [ExtConfig]
  /**
   * In versions prior to 4.2, using dotted Action names was not really meaningful,
   * because it generated flat →<code>namespace</code> object with dotted property
   * names. For example, take this API declaration:
   * <pre>
   *  {
   *      actions: {
   *          TestAction: [{
   *              name: 'foo',
   *              len:  1
   *          }],
   *          'TestAction.Foo' [{
   *              name: 'bar',
   *              len: 1
   *          }]
   *      },
   *      namespace: 'MyApp'
   *  }
   * </pre>
   * <p>Before 4.2, that would generate the following API object:</p>
   * <pre>
   *  window.MyApp = {
   *      TestAction: {
   *          foo: function() { ... }
   *      },
   *      'TestAction.Foo': {
   *          bar: function() { ... }
   *      }
   *  }
   * </pre>
   * <p>In Ext JS 4.2, we introduced new namespace handling behavior. Now the same API
   * object will be like this:</p>
   * <pre>
   *  window.MyApp = {
   *      TestAction: {
   *          foo: function() { ... },
   *
   *          Foo: {
   *              bar: function() { ... }
   *          }
   *      }
   *  }
   * </pre>
   * <p>Instead of addressing Action methods array-style <code>MyApp['TestAction.Foo'].bar()</code>,
   * now it is possible to use object addressing: <code>MyApp.TestAction.Foo.bar()</code>.</p>
   * <p>If you find this behavior undesirable, set this config option to <code>true</code>.</p>
   * @default false
   * @see #namespace
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-disableNestedActions Original Ext JS documentation of 'disableNestedActions'
   */
  public native function get disableNestedActions():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disableNestedActions(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> or <code>false</code> to enable or disable combining of method
   * calls. If a number is specified this is the amount of time in milliseconds
   * to wait before sending a batched request.
   * <p>Calls which are received within the specified timeframe will be
   * concatenated together and sent in a single request, optimizing the
   * application by reducing the amount of round trips that have to be made
   * to the server. To cancel buffering for some particular invocations, pass
   * <code>→timeout</code> parameter in <code>options</code> object for that method call.</p>
   * @default 10
   * @see #timeout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-enableBuffer Original Ext JS documentation of 'enableBuffer'
   */
  public native function get enableBuffer():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableBuffer(value:*):void;

  [ExtConfig]
  /**
   * Specify which param will hold the arguments for the method.
   * @default data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-enableUrlEncode Original Ext JS documentation of 'enableUrlEncode'
   */
  public native function get enableUrlEncode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableUrlEncode(value:String):void;

  [ExtConfig]
  /**
   * Number of times to re-attempt delivery on failure of a call.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-maxRetries Original Ext JS documentation of 'maxRetries'
   */
  public native function get maxRetries():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxRetries(value:Number):void;

  [ExtConfig]
  /**
   * Namespace for the Remoting Provider (defaults to <code>Ext.global</code>).
   * Explicitly specify the namespace Object, or specify a String to have a
   * →<code>ext.Ext.namespace()</code> created implicitly.
   * @see ext.SExt#namespace() ext.Ext.namespace()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-namespace Original Ext JS documentation of 'namespace'
   */
  public native function get namespace():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set namespace(value:*):void;

  [ExtConfig]
  /**
   * The timeout to use for each request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-timeout Original Ext JS documentation of 'timeout'
   */
  public native function get timeout():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  [ExtConfig]
  /**
   * <b>Required</b>. The url to connect to the →<code>ext.direct.DirectManager</code> server-side
   * router.
   * @see ext.direct.#DirectManager ext.direct.DirectManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#cfg-url Original Ext JS documentation of 'url'
   */
  public native function get url():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set url(value:String):void;

  /**
   * Connect the provider and start its service.
   * Provider will fire <code>connect</code> event upon successful connection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#method-connect Original Ext JS documentation of 'connect'
   */
  override public native function connect():void;
}
}