package ext.direct {
import ext.mixin.Observable;

[Native]
/**
 * @see ext.direct.events.DirectManager_event_providerEvent.EVENT
 * @eventType ext.direct.events.DirectManager_event_providerEvent.EVENT
 */
[Event(name='onEvent', type='ext.direct.events.DirectManager_event_providerEvent')]
/**
 * @see ext.direct.events.DirectManager_event_providerEvent.EXCEPTION
 * @eventType ext.direct.events.DirectManager_event_providerEvent.EXCEPTION
 */
[Event(name='onException', type='ext.direct.events.DirectManager_event_providerEvent')]
/**
 * @see ext.direct.events.DirectManager_url_providerEvent.PROVIDER_LOAD
 * @eventType ext.direct.events.DirectManager_url_providerEvent.PROVIDER_LOAD
 */
[Event(name='onProviderLoad', type='ext.direct.events.DirectManager_url_providerEvent')]
/**
 * @see ext.direct.events.DirectManager_url_errorEvent.PROVIDER_LOAD_ERROR
 * @eventType ext.direct.events.DirectManager_url_errorEvent.PROVIDER_LOAD_ERROR
 */
[Event(name='onProviderLoadError', type='ext.direct.events.DirectManager_url_errorEvent')]
/**
 * Ext Direct aims to streamline communication between the client and server
 * by providing a single interface that reduces the amount of common code
 * typically required to validate data and handle returned data packets
 * (reading data, error conditions, etc).
 * <p>The <code>Ext.direct</code> namespace includes several classes for a closer integration
 * with the server-side. The Ext.data namespace also includes classes for working
 * with Ext.data.Stores which are backed by data from an Ext Direct method.</p>
 * <p><b>Specification</b></p>
 * <p>For additional information consult the <a href="http://sencha.com/products/extjs/extdirect">Ext Direct Specification</a>.</p>
 * <p><b>Providers</b></p>
 * <p>Ext Direct uses a provider architecture, where one or more providers are used
 * to transport data to and from the server. There are several providers that exist
 * in the core at the moment:</p>
 * <ul>
 * <li>→<code>ext.direct.JsonProvider</code> for simple JSON operations</li>
 * <li>→<code>ext.direct.PollingProvider</code> for repeated requests</li>
 * <li>→<code>ext.direct.RemotingProvider</code> exposes server side to the client.</li>
 * </ul>
 * <p>A provider does not need to be invoked directly, providers are added via
 * <i>addProvider</i> (→<code>ext.direct.DirectManager</code>). RemotingProviders' API declarations
 * can also be loaded with <i>loadProvider</i> (→<code>ext.direct.DirectManager</code>), with
 * Provider instance created automatically after successful retrieval.</p>
 * <p><b>Router</b></p>
 * <p>Ext Direct RemotingProviders utilize a "router" on the server to direct
 * requests from the client to the appropriate server-side method. Because
 * the Ext Direct API is platform-agnostic, you could completely swap out
 * a Java based server solution and replace it with one that uses C#
 * without changing the client side JavaScript at all, or vice versa.</p>
 * <p><b>Server side events</b></p>
 * <p>Custom events from the server may be handled by the client by adding listeners, for example:</p>
 * <pre>
 * {"type":"event","name":"message","data":"Successfully polled at: 11:19:30 am"}
 *
 * // add a handler for a 'message' event sent by the server
 * Ext.direct.Manager.on('message', function(e){
 *     out.append(String.format('&lt;p&gt;&lt;i&gt;{0}&lt;/i&gt;&lt;/p&gt;', e.data));
 *     out.el.scrollTo('t', 100000, true);
 * });
 * </pre>
 * <p>Type of singleton DirectManager.</p>
 * @see ext.direct.JsonProvider
 * @see ext.direct.PollingProvider
 * @see ext.direct.RemotingProvider
 * @see ext.direct.#DirectManager ext.direct.DirectManager
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html Original Ext JS documentation of 'Ext.direct.Manager'
 */
public class SDirectManager extends Observable {
  /**
   * @inheritDoc
   */
  public function SDirectManager(config:Observable = null) {
    super();
  }

  /**
   * Exception types.
   * @default {
   *     TRANSPORT: 'xhr',
   *     PARSE: 'parse',
   *     DATA: 'data',
   *     LOGIN: 'login',
   *     SERVER: 'exception'
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html#property-exceptions Original Ext JS documentation of 'exceptions'
   */
  public native function get exceptions():*;

  /**
   * @private
   */
  public native function set exceptions(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Default variable name to use for Ext Direct API declaration.
   * @default "Ext.REMOTING_API"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html#cfg-varName Original Ext JS documentation of 'varName'
   * @see #getVarName()
   * @see #setVarName()
   */
  public native function get varName():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set varName(value:String):void;

  /**
   * Adds an Ext Direct Provider and creates the proxy or stub methods to execute
   * server-side methods for RemotingProviders. If the provider is not already connected,
   * it will auto-connect.
   * <pre>
   *  var pollProv = new Ext.direct.PollingProvider({
   *      id: 'polling1',
   *      url: 'php/poll2.php'
   *  });
   *
   *  Ext.direct.Manager.addProvider({
   *      id: 'remoting1',
   *      type: 'remoting',           // create a Ext.direct.RemotingProvider
   *      url:  'php/router.php',     // url to connect to the Ext Direct server-side router.
   *      actions: {                  // each property in actions object represents an Action
   *          TestAction: [{          // array of Methods within each server side Action
   *              name: 'doEcho',     // name of method
   *              len:  1
   *          }, {
   *              name: 'multiply',
   *              len:  1
   *          }, {
   *              name: 'doForm',
   *              formHandler: true   // handle form on server with Ext.direct.Transaction
   *          }]
   *      },
   *      namespace: 'myApplication', // namespace to create the Remoting Provider in
   *  }, {
   *      id:   'polling2',
   *      type: 'polling',            // create an Ext.direct.PollingProvider
   *      url:  'php/poll.php'
   *  },
   *  pollProv);                      // reference to previously created instance
   * </pre>
   * @param provider Accepts any number of Provider descriptions (an instance or config object for
   * a Provider). Each Provider description instructs Ext Direct how to create
   * client-side stub methods.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html#method-addProvider Original Ext JS documentation of 'addProvider'
   */
  public native function addProvider(...provider):void;

  /**
   * Retrieves a <i>provider</i> (→<code>ext.direct.Provider</code>) by the id specified when the
   * provider is added.
   * @param id The id of the provider, or the provider instance.
   * @see ext.direct.Provider
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html#method-getProvider Original Ext JS documentation of 'getProvider'
   */
  public native function getProvider(id:*):Provider;

  /**
   * Returns the value of <code>varName</code>.
   * @see #varName
   */
  public native function getVarName():String;

  /**
   * Load Ext Direct Provider API declaration from the server and construct
   * a new Provider instance. The new Provider will then auto-connect and
   * create stub functions for the methods exposed by the server side. See
   * →<code>addProvider()</code>.
   * <pre>
   *  Ext.direct.Manager.loadProvider({
   *      url: 'php/api.php',
   *      varName: 'MY_REMOTING_API' // defaults to 'Ext.REMOTING_API'
   *  });
   * </pre>
   * @param config Remoting API configuration.
   * <ul>
   * <li><code>url:String</code> (optional) —
   * URL to retrieve remoting API declaration from.
   * </li>
   * <li><code>varName:String</code> (optional) —
   * Name of the variable that will hold
   * RemotingProvider configuration block, including its Actions.
   * </li>
   * </ul>
   * @param callback Optional callback to execute when
   * Provider is created, or when an error has occured.
   * @param scope Optional scope to execute callback function in.
   * <p>For additional information see the [Ext Direct specification][1].</p>
   * @see SDirectManager#addProvider()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html#method-loadProvider Original Ext JS documentation of 'loadProvider'
   */
  public native function loadProvider(config:Object, callback:Function = null, scope:Object = null):void;

  /**
   * Parses a direct function. It may be passed in a string format, for example:
   * "MyApp.Person.read".
   * @param fn The direct function
   * @return The function to use in the direct call. Null if not found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html#method-parseMethod Original Ext JS documentation of 'parseMethod'
   */
  public native function parseMethod(fn:*):Function;

  /**
   * Removes the provider.
   * @param provider The provider instance or the id of the provider.
   * @return The provider, null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Manager.html#method-removeProvider Original Ext JS documentation of 'removeProvider'
   */
  public native function removeProvider(provider:*):Provider;

  /**
   * Sets the value of <code>varName</code>.
   * @param varName The new value.
   * @see #varName
   */
  public native function setVarName(varName:String):void;
}
}