package ext.direct.events {
import ext.direct.PollingProvider;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.direct.events.PollingProviderEvent")]
public class PollingProviderEvent extends FlExtEvent {
  /**
   * Fired immediately before a poll takes place.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html#event-beforepoll Original Ext JS documentation of 'beforepoll'
   * @see ext.direct.PollingProvider
   * @eventType onBeforePoll
   */
  public static const BEFORE_POLL:String = "onBeforePoll";
  /**
   * Fired immediately after a poll takes place.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.PollingProvider.html#event-poll Original Ext JS documentation of 'poll'
   * @see ext.direct.PollingProvider
   * @eventType onPoll
   */
  public static const POLL:String = "onPoll";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function PollingProviderEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():PollingProvider;
}
}