package ext.direct.events {
import ext.direct.Provider;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.direct.events.ProviderEvent")]
public class ProviderEvent extends FlExtEvent {
  /**
   * Fires when the Provider connects to the server-side
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#event-connect Original Ext JS documentation of 'connect'
   * @see ext.direct.Provider
   * @eventType onConnect
   */
  public static const CONNECT:String = "onConnect";
  /**
   * Fires when the Provider disconnects from the server-side
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.Provider.html#event-disconnect Original Ext JS documentation of 'disconnect'
   * @see ext.direct.Provider
   * @eventType onDisconnect
   */
  public static const DISCONNECT:String = "onDisconnect";
  public static const __PARAMETER_SEQUENCE__:Array = ["provider", "eOpts"];

  public function ProviderEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The →<code>ext.direct.Provider</code>.
   * @see ext.direct.Provider
   */
  public native function get provider():Provider;
}
}