package ext.direct.events {
import ext.direct.DirectEvent;
import ext.direct.RemotingProvider;
import ext.direct.Transaction;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.direct.events.RemotingProvider_event_transactionEvent")]
public class RemotingProvider_event_transactionEvent extends FlExtEvent {
  /**
   * Fires before callback function is executed. By returning <code>false</code> from an event handler
   * you can prevent the callback from executing.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.direct.RemotingProvider.html#event-beforecallback Original Ext JS documentation of 'beforecallback'
   * @see ext.direct.RemotingProvider
   * @eventType onBeforeCallback
   */
  public static const BEFORE_CALLBACK:String = "onBeforeCallback";
  public static const __PARAMETER_SEQUENCE__:Array = ["provider", "event", "transaction", "eOpts"];

  public function RemotingProvider_event_transactionEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Event associated with the callback invocation
   */
  public native function get event():DirectEvent;

  /**
   * The provider instance
   */
  public native function get provider():RemotingProvider;

  /**
   * Transaction for which the callback
   * is about to be fired
   */
  public native function get transaction():Transaction;
}
}