package ext.dom {

[Native("Ext.dom.CompositeElement", require)]
/**
 * This class encapsulates a <i>collection</i> of DOM elements, providing methods to filter members,
 * or to perform collective actions upon the whole set.
 * <p>Although they are not listed, this class supports all of the methods of →<code>ext.dom.Element</code>.
 * The methods from these classes will be performed on all the elements in this collection.</p>
 * <p>All methods return <i>this</i> and can be chained.</p>
 * <p>Usage:</p>
 * <pre>
 *  var els = Ext.select("#some-el div.some-class", true);
 *  // or select directly from an existing element
 *  var el = Ext.get('some-el');
 *  el.select('div.some-class', true);
 *
 *  els.setWidth(100); // all elements become 100 width
 *  els.hide(true); // all elements fade out and hide
 *  // or
 *  els.setWidth(100).hide(true);
 * </pre>
 * @see ext.dom.Element
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElement.html Original Ext JS documentation of 'Ext.dom.CompositeElement'
 */
public class CompositeElement extends CompositeElementLite {
  /**
   * @inheritDoc
   */
  public function CompositeElement(elements:Array) {
    super(elements);
  }
}
}