package ext.dom {
import js.HTMLElement;

[Native("Ext.dom.CompositeElementLite", require)]
/**
 * This class encapsulates a <i>collection</i> of DOM elements, providing methods to filter members,
 * or to perform collective actions upon the whole set.
 * <p>Although they are not listed, this class supports all of the methods of →<code>ext.dom.Element</code>.
 * The methods from these classes will be performed on all the elements in this collection.</p>
 * <p>Example:</p>
 * <pre>
 * var els = Ext.select("#some-el div.some-class");
 * // or select directly from an existing element
 * var el = Ext.get('some-el');
 * el.select('div.some-class');
 *
 * els.setWidth(100); // all elements become 100 width
 * els.hide(true); // all elements fade out and hide
 * // or
 * els.setWidth(100).hide(true);
 * </pre>
 * @see ext.dom.Element
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html Original Ext JS documentation of 'Ext.dom.CompositeElementLite'
 */
public class CompositeElementLite extends Element {
  /**
   * @inheritDoc
   */
  public function CompositeElementLite(elements:Array) {
    super(null);
  }

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#cfg-bubbleEvents Original Ext JS documentation of 'bubbleEvents'
   */
  public native function get bubbleEvents():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bubbleEvents(value:*):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#property-dom Original Ext JS documentation of 'dom'
   */
  override public native function get dom():HTMLElement;

  /**
   * @private
   */
  override public native function set dom(value:HTMLElement):void;

  [ArrayElementType("js.HTMLElement")]
  /**
   * <ul>
   * <li><code>skipValidation</code> —
   * The Array of DOM elements which this CompositeElement encapsulates.
   * <p>This will not <i>usually</i> be accessed in developers' code, but developers wishing
   * to augment the capabilities of the CompositeElementLite class may use it when adding
   * methods to the class.</p>
   * <p>For example to add the <code>nextAll</code> method to the class to <b>add</b> all following siblings
   * of selected elements, the code would be</p>
   * <pre>
   * Ext.override(Ext.dom.CompositeElementLite, {
   *     nextAll: function() {
   *         var elements = this.elements, i, l = elements.length, n, r = [], ri = -1;
   *
   *         // Loop through all elements in this Composite, accumulating
   *         // an Array of all siblings.
   *         for (i = 0; i &lt; l; i++) {
   *             for (n = elements[i].nextSibling; n; n = n.nextSibling) {
   *                 r[++ri] = n;
   *             }
   *         }
   *
   *         // Add all found siblings to this Composite
   *         return this.add(r);
   *     }
   * });
   * </pre>
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#property-elements Original Ext JS documentation of 'elements'
   */
  public native function get elements():Array;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#property-id Original Ext JS documentation of 'id'
   */
  override public native function get id():String;

  /**
   * @private
   */
  override public native function set id(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated CompositeElement,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#property-isComposite Original Ext JS documentation of 'isComposite'
   */
  public native function get isComposite():Boolean;

  /**
   * @private
   */
  public native function set isComposite(value:Boolean):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#cfg-listeners Original Ext JS documentation of 'listeners'
   * @see #setListeners()
   */
  override public native function get listeners():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set listeners(value:Object):void;

  /**
   * Adds elements to this Composite object.
   * @param els Either an Array of DOM elements
   * to add, or another Composite object who's elements should be added.
   * @param root The root element of the query or id of the root.
   * @return This Composite object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(els:*, root:* = undefined):CompositeElementLite;

  /**
   * Removes all elements from this Composite.
   * @param removeDom True to also remove the elements from the document.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear(removeDom:Boolean = false):void;

  /**
   * Returns <code>true</code> if this composite contains the passed element
   * @param el The id of an element,
   * or an Ext.Element, or an HtmlElement to find within the composite collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-contains Original Ext JS documentation of 'contains'
   */
  override public native function contains(el:*):Boolean;

  /**
   * Calls the passed function for each element in this composite.
   * @param fn The function to call.
   * <ul>
   * <li><code>el:ext.dom.Element</code> (optional) —
   * The current Element in the iteration. <b>This is the flyweight
   * (shared) Ext.dom.Element instance, so if you require a a reference to the dom node,
   * use el.dom.</b>
   * </li>
   * <li><code>c:ext.dom.CompositeElementLite</code> (optional) —
   * This Composite object.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The zero-based index in the iteration.
   * </li>
   * </ul>
   * @param scope The scope (this reference) in which the function is executed.
   * Defaults to the Element.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object = null):CompositeElementLite;

  /**
   * Clears this Composite and adds the elements passed.
   * @param els Either an array of DOM elements,
   * or another Composite from which to fill this Composite.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-fill Original Ext JS documentation of 'fill'
   */
  public native function fill(els:*):CompositeElementLite;

  /**
   * Filters this composite to only elements that match the passed selector.
   * @param selector A string CSS selector or a comparison function.
   * The comparison function will be called with the following arguments:
   * <ul>
   * <li><code>el:ext.dom.Element</code> (optional) —
   * The current DOM element.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The current index within the collection.
   * </li>
   * </ul>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-filter Original Ext JS documentation of 'filter'
   */
  public native function filter(selector:*):CompositeElementLite;

  /**
   * Returns the first Element
   * @param selector Find the next sibling that matches the passed simple selector.
   * See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * @param returnDom <code>true</code> to return a raw DOM node instead of
   * an Ext.dom.Element
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-first Original Ext JS documentation of 'first'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  override public native function first(selector:String = null, returnDom:Boolean = false):*;

  /**
   * Returns the number of elements in this Composite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * Find the index of the passed element within the composite collection.
   * @param el The id of an element, or an
   * Ext.dom.Element, or an HtmlElement to find within the composite collection.
   * @return The index of the passed Ext.dom.Element in the composite collection,
   * or -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  override public native function indexOf(el:*):Number;

  /**
   * Returns a flyweight Element of the dom element object at the specified index.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-item Original Ext JS documentation of 'item'
   */
  public native function item(index:Number):Element;

  /**
   * Returns the last Element
   * @param selector Find the previous sibling that matches the passed simple
   * selector. See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * @param returnDom <code>true</code> to return a raw DOM node instead of an
   * Ext.dom.Element
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-last Original Ext JS documentation of 'last'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  override public native function last(selector:String = null, returnDom:Boolean = false):*;

  /**
   * Removes the specified element(s).
   * @param keys The id of an element, the Element
   * itself, the index of the element in this composite or an array of any of those.
   * @param removeDom <code>true</code> to also remove the element from the document
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-removeElement Original Ext JS documentation of 'removeElement'
   */
  public native function removeElement(keys:*, removeDom:Boolean = false):CompositeElementLite;

  /**
   * Replaces the specified element with the passed element.
   * @param el The id of an element, the Element
   * itself, the index of the element in this composite to replace.
   * @param replacement The id of an element or the Element itself.
   * @param domReplace <code>true</code> to remove and replace the element in the document too.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-replaceElement Original Ext JS documentation of 'replaceElement'
   */
  public native function replaceElement(el:*, replacement:*, domReplace:Boolean = false):CompositeElementLite;

  [ArrayElementType("js.HTMLElement")]
  /**
   * Gets a range nodes.
   * @param start The index of the first node in the range
   * @param end The index of the last node in the range
   * @return An array of nodes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.CompositeElementLite.html#method-slice Original Ext JS documentation of 'slice'
   */
  public native function slice(start:Number = NaN, end:Number = NaN):Array;
}
}